/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.test.test12;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Date;
import jcolibri.extensions.textual.IE.common.DomainTopicClassifier;
import jcolibri.extensions.textual.IE.common.FeaturesExtractor;
import jcolibri.extensions.textual.IE.common.PhrasesExtractor;
import jcolibri.extensions.textual.IE.common.StopWordsDetector;
import jcolibri.extensions.textual.IE.common.TextStemmer;
import jcolibri.extensions.textual.IE.opennlp.IETextOpenNLP;
import jcolibri.extensions.textual.IE.opennlp.OpennlpMainNamesExtractor;
import jcolibri.extensions.textual.IE.opennlp.OpennlpPOStagger;
import jcolibri.extensions.textual.IE.opennlp.OpennlpSplitter;
import jcolibri.util.FileIO;
import org.apache.commons.logging.LogFactory;

public class TestOpenNLP {
    public static void main(String[] args) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(FileIO.findFile("jcolibri/test/test12/restest.txt").openStream()));
            String content = "";
            while ((line = br.readLine()) != null) {
                content = String.valueOf(content) + line + "\n";
            }
            long startTime = new Date().getTime();
            IETextOpenNLP text = new IETextOpenNLP(content);
            OpennlpSplitter.split(text);
            StopWordsDetector.detectStopWords(text);
            TextStemmer.stem(text);
            OpennlpPOStagger.tag(text);
            OpennlpMainNamesExtractor.extractMainNames(text);
            PhrasesExtractor.loadRules(FileIO.findFile("jcolibri/test/test12/phrasesRules.txt").getPath());
            PhrasesExtractor.extractPhrases(text);
            FeaturesExtractor.loadRules("jcolibri/test/test12/featuresRules.txt");
            FeaturesExtractor.extractFeatures(text);
            DomainTopicClassifier.loadRules("jcolibri/test/test12/domainRules.txt");
            DomainTopicClassifier.classifyWithTopic(text);
            System.out.println(text.printAnnotations());
            long endTime = new Date().getTime();
            System.out.println("Total time: " + (endTime - startTime) + " milliseconds");
        }
        catch (Exception e) {
            LogFactory.getLog(TestOpenNLP.class).error((Object)e);
        }
    }
}

