/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.test.test15;

import jcolibri.casebase.CachedLinealCaseBase;
import jcolibri.cbraplications.StandardCBRApplication;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.cbrcore.Connector;
import jcolibri.connector.PlainTextConnector;
import jcolibri.evaluation.Evaluator;
import jcolibri.exception.ExecutionException;
import jcolibri.extensions.maintenance_evaluation.DetailedEvaluationReport;
import jcolibri.method.retrieve.NNretrieval.similarity.global.Average;
import jcolibri.method.retrieve.NNretrieval.similarity.local.Interval;
import jcolibri.method.reuse.classification.KNNClassificationConfig;
import jcolibri.method.reuse.classification.SimilarityWeightedVotingMethod;
import jcolibri.method.revise.classification.BasicClassificationOracle;
import jcolibri.test.test15.IrisDescription;
import jcolibri.util.FileIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IrisEvaluableApp
implements StandardCBRApplication {
    Connector _connector;
    CBRCaseBase _caseBase;
    KNNClassificationConfig irisSimConfig;
    private Log log;
    public static final String DATA_SERIES_NAME = "Iris Prediction Cost";

    public void configure() throws ExecutionException {
        try {
            this._connector = new PlainTextConnector();
            this._connector.initFromXMLfile(FileIO.findFile("jcolibri/test/test15/plaintextconfig.xml"));
            this._caseBase = new CachedLinealCaseBase();
            this.irisSimConfig = new KNNClassificationConfig();
            this.irisSimConfig.setDescriptionSimFunction(new Average());
            this.irisSimConfig.addMapping(new Attribute("sepalLength", IrisDescription.class), new Interval(3.6));
            this.irisSimConfig.addMapping(new Attribute("sepalWidth", IrisDescription.class), new Interval(2.4));
            this.irisSimConfig.addMapping(new Attribute("petalLength", IrisDescription.class), new Interval(5.9));
            this.irisSimConfig.addMapping(new Attribute("petalWidth", IrisDescription.class), new Interval(2.4));
            this.irisSimConfig.setClassificationMethod(new SimilarityWeightedVotingMethod());
            this.irisSimConfig.setK(3);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
        this.log = LogFactory.getLog(this.getClass());
    }

    public CBRCaseBase preCycle() throws ExecutionException {
        this._caseBase.init(this._connector);
        return this._caseBase;
    }

    public void cycle(CBRQuery query) throws ExecutionException {
        this.log.info((Object)("Query: " + query.getDescription()));
        BasicClassificationOracle oracle = new BasicClassificationOracle();
        double predictionCost = oracle.getPredictionCost(query, this._caseBase, this.irisSimConfig);
        ((DetailedEvaluationReport)Evaluator.getEvaluationReport()).addDataToSeries(DATA_SERIES_NAME, query, predictionCost);
    }

    public void postCycle() throws ExecutionException {
        this._connector.close();
    }
}

