/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.textual.lucene;

import java.io.IOException;
import java.util.HashMap;
import jcolibri.extensions.textual.lucene.LuceneDocument;
import jcolibri.extensions.textual.lucene.LuceneIndex;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Hit;
import org.apache.lucene.search.Hits;

public class LuceneSearchResult {
    private String[] _pos2id;
    private HashMap<String, Integer> _id2pos;
    private float[] _pos2score;
    private int resultLength;
    private LuceneIndex index;
    private float maxscore;

    protected LuceneSearchResult(Hits hits, LuceneIndex index) throws IOException {
        this.index = index;
        this.resultLength = hits.length();
        this._pos2id = new String[this.resultLength];
        this._pos2score = new float[this.resultLength];
        this._id2pos = new HashMap(this.resultLength);
        this.maxscore = 0.0f;
        int pos = 0;
        for (Hit hit : hits) {
            String id;
            Document doc = hit.getDocument();
            this._pos2id[pos] = id = doc.get(LuceneDocument.ID_FIELD);
            this._pos2score[pos] = hit.getScore();
            this._id2pos.put(id, new Integer(pos));
            if (hit.getScore() > this.maxscore) {
                this.maxscore = hit.getScore();
            }
            ++pos;
        }
    }

    public int getDocPosition(String docID) {
        Integer pos = this._id2pos.get(docID);
        if (pos == null) {
            return -1;
        }
        return pos;
    }

    public LuceneDocument getDocAt(int position) {
        if (position < this.resultLength) {
            return this.index.getDocument(this._pos2id[position]);
        }
        return null;
    }

    public float getDocScore(String docID, boolean normalized) {
        int pos = this.getDocPosition(docID);
        if (pos == -1) {
            return 0.0f;
        }
        return this.getDocScore(pos, normalized);
    }

    public float getDocScore(int position, boolean normalized) {
        if (position >= this.resultLength) {
            return 0.0f;
        }
        if (normalized) {
            return this._pos2score[position] / this.maxscore;
        }
        return this._pos2score[position];
    }

    public String getContent(int position, String fieldName) {
        if (position >= this.resultLength) {
            return null;
        }
        String id = this._pos2id[position];
        return this.index.getDocument(id).getContentField(fieldName);
    }

    public int getResultLength() {
        return this.resultLength;
    }
}

