/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.test.test16;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.evaluation.EvaluationReport;
import jcolibri.evaluation.Evaluator;
import jcolibri.evaluation.evaluators.HoldOutEvaluator;
import jcolibri.evaluation.evaluators.LeaveOneOutEvaluator;
import jcolibri.evaluation.evaluators.NFoldEvaluator;
import jcolibri.evaluation.evaluators.SameSplitEvaluator;
import jcolibri.evaluation.tools.EvaluationResultGUI;
import jcolibri.exception.ExecutionException;
import jcolibri.extensions.textual.IE.common.StopWordsDetector;
import jcolibri.extensions.textual.IE.common.TextStemmer;
import jcolibri.extensions.textual.IE.opennlp.OpennlpSplitter;
import jcolibri.extensions.visualization.CasesVisualization;
import jcolibri.method.retrieve.NNretrieval.similarity.LocalSimilarityFunction;
import jcolibri.method.retrieve.NNretrieval.similarity.local.textual.CosineCoefficient;
import jcolibri.method.retrieve.NNretrieval.similarity.local.textual.DiceCoefficient;
import jcolibri.method.retrieve.NNretrieval.similarity.local.textual.JaccardCoefficient;
import jcolibri.method.retrieve.NNretrieval.similarity.local.textual.OverlapCoefficient;
import jcolibri.method.retrieve.NNretrieval.similarity.local.textual.compressionbased.CompressionBased;
import jcolibri.method.retrieve.NNretrieval.similarity.local.textual.compressionbased.GZipCompressor;
import jcolibri.method.retrieve.NNretrieval.similarity.local.textual.compressionbased.NormalisedCompression;
import jcolibri.method.reuse.classification.AbstractKNNClassificationMethod;
import jcolibri.method.reuse.classification.MajorityVotingMethod;
import jcolibri.method.reuse.classification.SimilarityWeightedVotingMethod;
import jcolibri.method.reuse.classification.UnanimousVotingMethod;
import jcolibri.test.main.SwingProgressBar;
import jcolibri.test.test16.SpamFilterApp;
import jcolibri.util.ProgressController;
import org.apache.commons.logging.LogFactory;

public class Test16
extends JFrame {
    private static final long serialVersionUID = 1L;
    JRadioButton corpus300;
    JRadioButton corpus600;
    JRadioButton leaveOneOut;
    JRadioButton holdOutFixed10;
    JRadioButton holdOutFixed20;
    JRadioButton holdOutFixed30;
    JRadioButton sameSplit;
    JRadioButton sameSplitGenerate;
    JButton saveSplit;
    JTextField sameSplitGenerateFile;
    JRadioButton sameSplitReuse;
    JButton loadSplit;
    JTextField sameSplitReuseFile;
    JLabel sameSplitGeneratePercent;
    SpinnerNumberModel sameSplitPercent;
    JSpinner sameSplitGeneratePercentSpinner;
    JRadioButton holdOut;
    JLabel holdOutLabel1;
    SpinnerNumberModel holdOutPercent;
    JSpinner holdOutPercentSpinner;
    JLabel holdOutLabel2;
    SpinnerNumberModel holdOutRepetitions;
    JSpinner holdOutRepetitionsSpinner;
    JRadioButton nFold;
    JLabel nFoldLabel1;
    SpinnerNumberModel nFoldFolds;
    JSpinner nFoldFoldsSpinner;
    JLabel nFoldLabel2;
    SpinnerNumberModel nFoldRepetitions;
    JSpinner nFoldRepetitionsSpinner;
    JRadioButton compressionBased;
    JRadioButton normalizedCompression;
    JRadioButton cosine;
    JRadioButton dice;
    JRadioButton jaccard;
    JRadioButton overlap;
    JRadioButton majorityVoting;
    JRadioButton weightedVoting;
    JRadioButton unanimousVoting;
    SpinnerNumberModel kValue;
    JSpinner kValueSpinner;
    JButton evaluate;
    JButton visualize;

    public Test16() {
        this.configure();
    }

    public void configure() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        JPanel corpusPanel = new JPanel();
        corpusPanel.setLayout(new GridLayout(2, 1));
        corpusPanel.setBorder(BorderFactory.createTitledBorder("Corpus"));
        this.corpus300 = new JRadioButton("Corpus - 300 emails");
        this.corpus600 = new JRadioButton("Corpus - 600 emails");
        ButtonGroup corpusGroup = new ButtonGroup();
        corpusGroup.add(this.corpus300);
        corpusGroup.add(this.corpus600);
        corpusPanel.add(this.corpus300);
        corpusPanel.add(this.corpus600);
        this.corpus300.setSelected(true);
        JPanel evaluatorPanel = new JPanel();
        evaluatorPanel.setBorder(BorderFactory.createTitledBorder("Evaluator"));
        evaluatorPanel.setLayout(new BoxLayout(evaluatorPanel, 1));
        this.leaveOneOut = new JRadioButton("Leave One Out");
        this.leaveOneOut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Test16.this.enableGroup("none");
            }
        });
        this.holdOutFixed10 = new JRadioButton("Hold Out - Query Set Fixed 10%");
        this.holdOutFixed10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Test16.this.enableGroup("none");
            }
        });
        this.holdOutFixed20 = new JRadioButton("Hold Out - Query Set Fixed 20%");
        this.holdOutFixed20.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Test16.this.enableGroup("none");
            }
        });
        this.holdOutFixed30 = new JRadioButton("Hold Out - Query Set Fixed 30%");
        this.holdOutFixed30.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Test16.this.enableGroup("none");
            }
        });
        this.sameSplit = new JRadioButton("Hold Out - Query Set Custom");
        this.sameSplit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Test16.this.enableGroup("samesplit");
            }
        });
        JPanel sameSplitPanel = new JPanel();
        sameSplitPanel.setLayout(new BoxLayout(sameSplitPanel, 1));
        sameSplitPanel.setBorder(BorderFactory.createEmptyBorder(2, 15, 2, 2));
        JPanel sameSplitPanel1 = new JPanel();
        this.sameSplitGenerate = new JRadioButton("Generate New Query Set & Evaluate");
        this.sameSplitGenerate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Test16.this.loadSplit.setEnabled(false);
                Test16.this.sameSplitReuseFile.setEnabled(false);
                Test16.this.saveSplit.setEnabled(true);
                Test16.this.sameSplitGenerateFile.setEnabled(true);
                Test16.this.sameSplitGeneratePercentSpinner.setEnabled(true);
                Test16.this.sameSplitGeneratePercent.setEnabled(true);
            }
        });
        this.saveSplit = new JButton("Save Query Set");
        this.sameSplitGenerateFile = new JTextField(20);
        this.saveSplit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser jfc = new JFileChooser(".");
                int returnVal = jfc.showSaveDialog(null);
                if (returnVal == 0) {
                    Test16.this.sameSplitGenerateFile.setText(jfc.getSelectedFile().toString());
                }
            }
        });
        JPanel sameSplitPanel1b = new JPanel();
        this.sameSplitGeneratePercent = new JLabel("Query Set percent:");
        this.sameSplitPercent = new SpinnerNumberModel(10, 5, 95, 5);
        this.sameSplitGeneratePercentSpinner = new JSpinner(this.sameSplitPercent);
        JPanel sameSplitPanel2 = new JPanel();
        this.sameSplitReuse = new JRadioButton("Evaluate Using Existing Query Set");
        this.sameSplitReuse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Test16.this.loadSplit.setEnabled(true);
                Test16.this.sameSplitReuseFile.setEnabled(true);
                Test16.this.saveSplit.setEnabled(false);
                Test16.this.sameSplitGenerateFile.setEnabled(false);
                Test16.this.sameSplitGeneratePercentSpinner.setEnabled(false);
                Test16.this.sameSplitGeneratePercent.setEnabled(false);
            }
        });
        this.loadSplit = new JButton("Open Query Set");
        this.sameSplitReuseFile = new JTextField(20);
        this.loadSplit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser jfc = new JFileChooser(".");
                int returnVal = jfc.showOpenDialog(null);
                if (returnVal == 0) {
                    Test16.this.sameSplitReuseFile.setText(jfc.getSelectedFile().toString());
                }
            }
        });
        sameSplitPanel1.add(this.saveSplit);
        sameSplitPanel1.add(this.sameSplitGenerateFile);
        sameSplitPanel1b.add(this.sameSplitGeneratePercent);
        sameSplitPanel1b.add(this.sameSplitGeneratePercentSpinner);
        sameSplitPanel2.add(this.loadSplit);
        sameSplitPanel2.add(this.sameSplitReuseFile);
        sameSplitPanel.add(this.sameSplitGenerate);
        sameSplitPanel.add(sameSplitPanel1);
        sameSplitPanel.add(sameSplitPanel1b);
        sameSplitPanel.add(this.sameSplitReuse);
        sameSplitPanel.add(sameSplitPanel2);
        sameSplitPanel1.setAlignmentX(0.0f);
        sameSplitPanel2.setAlignmentX(0.0f);
        sameSplitPanel1b.setAlignmentX(0.0f);
        ButtonGroup sameSplitGroup = new ButtonGroup();
        sameSplitGroup.add(this.sameSplitGenerate);
        sameSplitGroup.add(this.sameSplitReuse);
        this.sameSplitGenerate.setSelected(true);
        this.loadSplit.setEnabled(false);
        this.sameSplitReuseFile.setEnabled(false);
        this.holdOut = new JRadioButton("Hold Out - Query Set Random");
        this.holdOut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Test16.this.enableGroup("holdout");
            }
        });
        JPanel holdOutOptions = new JPanel();
        this.holdOutLabel1 = new JLabel("Query Set Percent");
        holdOutOptions.add(this.holdOutLabel1);
        this.holdOutPercent = new SpinnerNumberModel(10, 5, 95, 5);
        this.holdOutPercentSpinner = new JSpinner(this.holdOutPercent);
        holdOutOptions.add(this.holdOutPercentSpinner);
        this.holdOutLabel2 = new JLabel("Repetitions");
        holdOutOptions.add(this.holdOutLabel2);
        this.holdOutRepetitions = new SpinnerNumberModel(1, 1, 10, 1);
        this.holdOutRepetitionsSpinner = new JSpinner(this.holdOutRepetitions);
        holdOutOptions.add(this.holdOutRepetitionsSpinner);
        this.nFold = new JRadioButton("N-Fold - Random");
        this.nFold.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Test16.this.enableGroup("nfold");
            }
        });
        JPanel nFoldOptions = new JPanel();
        this.nFoldLabel1 = new JLabel("Folds");
        nFoldOptions.add(this.nFoldLabel1);
        this.nFoldFolds = new SpinnerNumberModel(4, 2, 10, 1);
        this.nFoldFoldsSpinner = new JSpinner(this.nFoldFolds);
        nFoldOptions.add(this.nFoldFoldsSpinner);
        this.nFoldLabel2 = new JLabel("Repetitions");
        nFoldOptions.add(this.nFoldLabel2);
        this.nFoldRepetitions = new SpinnerNumberModel(1, 1, 10, 1);
        this.nFoldRepetitionsSpinner = new JSpinner(this.nFoldRepetitions);
        nFoldOptions.add(this.nFoldRepetitionsSpinner);
        ButtonGroup evaluatorGroup = new ButtonGroup();
        evaluatorGroup.add(this.leaveOneOut);
        evaluatorGroup.add(this.holdOutFixed10);
        evaluatorGroup.add(this.holdOutFixed20);
        evaluatorGroup.add(this.holdOutFixed30);
        evaluatorGroup.add(this.sameSplit);
        evaluatorGroup.add(this.holdOut);
        evaluatorGroup.add(this.nFold);
        evaluatorPanel.add(this.leaveOneOut);
        evaluatorPanel.add(this.holdOutFixed10);
        evaluatorPanel.add(this.holdOutFixed20);
        evaluatorPanel.add(this.holdOutFixed30);
        evaluatorPanel.add(this.holdOut);
        evaluatorPanel.add(holdOutOptions);
        evaluatorPanel.add(this.nFold);
        evaluatorPanel.add(nFoldOptions);
        evaluatorPanel.add(this.sameSplit);
        evaluatorPanel.add(sameSplitPanel);
        this.leaveOneOut.setAlignmentX(0.0f);
        this.holdOutFixed10.setAlignmentX(0.0f);
        this.holdOutFixed20.setAlignmentX(0.0f);
        this.holdOutFixed30.setAlignmentX(0.0f);
        this.sameSplit.setAlignmentX(0.0f);
        sameSplitPanel.setAlignmentX(0.0f);
        this.holdOut.setAlignmentX(0.0f);
        holdOutOptions.setAlignmentX(0.0f);
        this.nFold.setAlignmentX(0.0f);
        nFoldOptions.setAlignmentX(0.0f);
        this.leaveOneOut.setSelected(true);
        this.setEnabledHoldOut(false);
        this.setEnabledNFold(false);
        this.setEnabledSameSplit(false);
        JPanel similPanel = new JPanel();
        similPanel.setBorder(BorderFactory.createTitledBorder("Similarity Function"));
        similPanel.setLayout(new GridLayout(6, 1));
        this.compressionBased = new JRadioButton("Compression");
        this.normalizedCompression = new JRadioButton("Normalized Compression");
        this.cosine = new JRadioButton("Cosine Coefficient");
        this.dice = new JRadioButton("Dice Coefficient");
        this.jaccard = new JRadioButton("Jaccard Coefficient");
        this.overlap = new JRadioButton("Overlap Coefficient");
        ButtonGroup similGroup = new ButtonGroup();
        similGroup.add(this.compressionBased);
        similGroup.add(this.normalizedCompression);
        similGroup.add(this.cosine);
        similGroup.add(this.dice);
        similGroup.add(this.jaccard);
        similGroup.add(this.overlap);
        similPanel.add(this.compressionBased);
        similPanel.add(this.normalizedCompression);
        similPanel.add(this.cosine);
        similPanel.add(this.dice);
        similPanel.add(this.jaccard);
        similPanel.add(this.overlap);
        this.compressionBased.setSelected(true);
        JPanel clasifPanel = new JPanel();
        clasifPanel.setBorder(BorderFactory.createTitledBorder("KNN Classification Method"));
        clasifPanel.setLayout(new GridLayout(4, 1));
        this.majorityVoting = new JRadioButton("Majority Voting Method");
        this.weightedVoting = new JRadioButton("Weighted Voting Method");
        this.unanimousVoting = new JRadioButton("Unanimous Voting Method");
        JPanel kPanel = new JPanel();
        kPanel.add(new JLabel("K value"));
        this.kValue = new SpinnerNumberModel(3, 1, 10, 1);
        this.kValueSpinner = new JSpinner(this.kValue);
        kPanel.add(this.kValueSpinner);
        ButtonGroup clasifGroup = new ButtonGroup();
        clasifGroup.add(this.majorityVoting);
        clasifGroup.add(this.weightedVoting);
        clasifGroup.add(this.unanimousVoting);
        clasifPanel.add(kPanel);
        clasifPanel.add(this.weightedVoting);
        clasifPanel.add(this.majorityVoting);
        clasifPanel.add(this.unanimousVoting);
        this.weightedVoting.setSelected(true);
        JPanel buttons = new JPanel();
        this.evaluate = new JButton("Evaluate Application");
        this.visualize = new JButton("Visualize Case Base using Similarity Function");
        buttons.add(this.evaluate);
        buttons.add(this.visualize);
        this.evaluate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Test16.this.evaluate();
            }
        });
        this.visualize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Test16.this.visualize();
            }
        });
        SwingProgressBar listener = new SwingProgressBar();
        ProgressController.clear();
        ProgressController.register(listener, CasesVisualization.class);
        ProgressController.register(listener, LeaveOneOutEvaluator.class);
        ProgressController.register(listener, NFoldEvaluator.class);
        ProgressController.register(listener, SameSplitEvaluator.class);
        ProgressController.register(listener, HoldOutEvaluator.class);
        ProgressController.register(listener, OpennlpSplitter.class);
        ProgressController.register(listener, StopWordsDetector.class);
        ProgressController.register(listener, TextStemmer.class);
        JPanel central = new JPanel();
        central.setLayout(new BoxLayout(central, 0));
        central.add(corpusPanel);
        central.add(similPanel);
        central.add(evaluatorPanel);
        central.add(clasifPanel);
        JPanel main = new JPanel();
        main.setLayout(new BorderLayout());
        main.add((Component)central, "Center");
        main.add((Component)buttons, "South");
        this.getContentPane().add(main);
        this.pack();
        this.setTitle("Spam Filter Toy");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - this.getWidth()) / 2, (screenSize.height - this.getHeight()) / 2, this.getWidth(), this.getHeight());
    }

    void enableGroup(String group) {
        if (group.equals("nfold")) {
            this.setEnabledNFold(true);
            this.setEnabledHoldOut(false);
            this.setEnabledSameSplit(false);
        } else if (group.equals("holdout")) {
            this.setEnabledNFold(false);
            this.setEnabledSameSplit(false);
            this.setEnabledHoldOut(true);
        } else if (group.equals("samesplit")) {
            this.setEnabledNFold(false);
            this.setEnabledSameSplit(true);
            this.setEnabledHoldOut(false);
        } else if (group.equals("none")) {
            this.setEnabledNFold(false);
            this.setEnabledSameSplit(false);
            this.setEnabledHoldOut(false);
        }
    }

    private void setEnabledSameSplit(boolean enabled) {
        this.sameSplitGenerate.setEnabled(enabled);
        this.sameSplitReuse.setEnabled(enabled);
        if (!enabled) {
            this.saveSplit.setEnabled(enabled);
            this.loadSplit.setEnabled(enabled);
            this.sameSplitGenerateFile.setEnabled(enabled);
            this.sameSplitReuseFile.setEnabled(enabled);
            this.sameSplitGeneratePercentSpinner.setEnabled(enabled);
            this.sameSplitGeneratePercent.setEnabled(enabled);
        } else if (this.sameSplitGenerate.isSelected()) {
            this.saveSplit.setEnabled(true);
            this.sameSplitGenerateFile.setEnabled(true);
            this.sameSplitGeneratePercentSpinner.setEnabled(true);
            this.sameSplitGeneratePercent.setEnabled(true);
        } else {
            this.loadSplit.setEnabled(true);
            this.sameSplitReuseFile.setEnabled(true);
        }
    }

    private void setEnabledNFold(boolean enabled) {
        this.nFoldLabel1.setEnabled(enabled);
        this.nFoldLabel2.setEnabled(enabled);
        this.nFoldFoldsSpinner.setEnabled(enabled);
        this.nFoldRepetitionsSpinner.setEnabled(enabled);
    }

    private void setEnabledHoldOut(boolean enabled) {
        this.holdOutLabel1.setEnabled(enabled);
        this.holdOutLabel2.setEnabled(enabled);
        this.holdOutPercentSpinner.setEnabled(enabled);
        this.holdOutRepetitionsSpinner.setEnabled(enabled);
    }

    void setButtonsEnabled(boolean enabled) {
        this.visualize.setEnabled(enabled);
        this.evaluate.setEnabled(enabled);
    }

    void evaluate() {
        SpamFilterApp app = this.configureApp();
        Thread thread = new Thread(new Evaluation(app));
        thread.start();
    }

    void visualize() {
        SpamFilterApp app = this.configureApp();
        Thread thread = new Thread(new Visualization(app));
        thread.start();
    }

    private SpamFilterApp configureApp() {
        String corpusFile = null;
        if (this.corpus300.isSelected()) {
            corpusFile = "jcolibri/test/test16/corpus300.zip";
        } else if (this.corpus600.isSelected()) {
            corpusFile = "jcolibri/test/test16/corpus600.zip";
        }
        LocalSimilarityFunction similFunc = null;
        if (this.compressionBased.isSelected()) {
            similFunc = new CompressionBased(new GZipCompressor());
        } else if (this.normalizedCompression.isSelected()) {
            similFunc = new NormalisedCompression(new GZipCompressor());
        } else if (this.cosine.isSelected()) {
            similFunc = new CosineCoefficient();
        } else if (this.dice.isSelected()) {
            similFunc = new DiceCoefficient();
        } else if (this.jaccard.isSelected()) {
            similFunc = new JaccardCoefficient();
        } else if (this.overlap.isSelected()) {
            similFunc = new OverlapCoefficient();
        }
        AbstractKNNClassificationMethod classifMethod = null;
        if (this.majorityVoting.isSelected()) {
            classifMethod = new MajorityVotingMethod();
        } else if (this.weightedVoting.isSelected()) {
            classifMethod = new SimilarityWeightedVotingMethod();
        } else if (this.unanimousVoting.isSelected()) {
            classifMethod = new UnanimousVotingMethod("spam");
        }
        int k = this.kValue.getNumber().intValue();
        SpamFilterApp app = new SpamFilterApp(corpusFile);
        app.setSimilFunc(similFunc);
        app.setClasifMethod(classifMethod);
        app.setK(k);
        return app;
    }

    public static void main(String[] args) {
        Test16 test = new Test16();
        test.setVisible(true);
    }

    class Evaluation
    implements Runnable {
        SpamFilterApp app;

        Evaluation(SpamFilterApp app) {
            this.app = app;
        }

        public void run() {
            Test16.this.setButtonsEnabled(false);
            try {
                int repetitions;
                Evaluator eval;
                if (Test16.this.leaveOneOut.isSelected()) {
                    eval = new LeaveOneOutEvaluator();
                    ((LeaveOneOutEvaluator)eval).init(this.app);
                    ((LeaveOneOutEvaluator)eval).LeaveOneOut();
                } else if (Test16.this.sameSplit.isSelected()) {
                    eval = new SameSplitEvaluator();
                    ((SameSplitEvaluator)eval).init(this.app);
                    if (Test16.this.sameSplitGenerate.isSelected()) {
                        String file = Test16.this.sameSplitGenerateFile.getText();
                        int percent = Test16.this.sameSplitPercent.getNumber().intValue();
                        ((SameSplitEvaluator)eval).generateSplit(percent, file);
                        ((SameSplitEvaluator)eval).HoldOutfromFile(file);
                    } else if (Test16.this.sameSplitReuse.isSelected()) {
                        ((SameSplitEvaluator)eval).HoldOutfromFile(Test16.this.sameSplitReuseFile.getText());
                    }
                } else if (Test16.this.holdOut.isSelected()) {
                    eval = new HoldOutEvaluator();
                    ((HoldOutEvaluator)eval).init(this.app);
                    int testPercent = Test16.this.holdOutPercent.getNumber().intValue();
                    repetitions = Test16.this.holdOutRepetitions.getNumber().intValue();
                    ((HoldOutEvaluator)eval).HoldOut(testPercent, repetitions);
                } else if (Test16.this.nFold.isSelected()) {
                    eval = new NFoldEvaluator();
                    ((NFoldEvaluator)eval).init(this.app);
                    int folds = Test16.this.nFoldFolds.getNumber().intValue();
                    repetitions = Test16.this.nFoldRepetitions.getNumber().intValue();
                    ((NFoldEvaluator)eval).NFoldEvaluation(folds, repetitions);
                } else {
                    String filename = "jcolibri/test/test16/splits/corpus";
                    filename = Test16.this.corpus300.isSelected() ? String.valueOf(filename) + "300-" : String.valueOf(filename) + "600-";
                    if (Test16.this.holdOutFixed10.isSelected()) {
                        filename = String.valueOf(filename) + "10.split";
                    } else if (Test16.this.holdOutFixed20.isSelected()) {
                        filename = String.valueOf(filename) + "20.split";
                    } else if (Test16.this.holdOutFixed30.isSelected()) {
                        filename = String.valueOf(filename) + "30.split";
                    }
                    SameSplitEvaluator eval2 = new SameSplitEvaluator();
                    eval2.init(this.app);
                    eval2.HoldOutfromFile(filename);
                }
                double tp = this.app.getTruePositives();
                double fp = this.app.getFalsePositives();
                double fn = this.app.getFalseNegatives();
                double tn = this.app.getTrueNegatives();
                double precision = tp / (tp + fp);
                double recall = tp / (tp + fn);
                EvaluationReport report = Evaluator.getEvaluationReport();
                report.putOtherData("Precision", String.valueOf(precision));
                report.putOtherData("Recall", String.valueOf(recall));
                report.putOtherData("True Spam", String.valueOf(tp));
                report.putOtherData("True Ham", String.valueOf(tn));
                report.putOtherData("False Spam", String.valueOf(fp));
                report.putOtherData("False Ham", String.valueOf(fn));
                System.out.println(report);
                EvaluationResultGUI.show(report, "Spam Filter Toy - Evaluation", false);
            }
            catch (Exception e) {
                LogFactory.getLog(SpamFilterApp.class).error((Object)e);
            }
            Test16.this.setButtonsEnabled(true);
        }
    }

    class Visualization
    implements Runnable {
        SpamFilterApp app;

        Visualization(SpamFilterApp app) {
            this.app = app;
        }

        public void run() {
            Test16.this.setButtonsEnabled(false);
            try {
                this.app.configure();
                CBRCaseBase _caseBase = this.app.preCycle();
                CasesVisualization.visualize(_caseBase.getCases(), this.app.getKNNConfig());
            }
            catch (ExecutionException e) {
                LogFactory.getLog(SpamFilterApp.class).error((Object)e);
            }
            Test16.this.setButtonsEnabled(true);
        }
    }
}

