/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.reuse;

import java.util.Collection;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.cbrcore.CaseComponent;
import jcolibri.exception.AttributeAccessException;
import jcolibri.util.AttributeUtils;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericDirectProportionMethod {
    public static void directProportion(Attribute source, Attribute destination, CBRQuery query, Collection<CBRCase> cases) {
        Object qs = AttributeUtils.findValue(source, query);
        if (qs == null) {
            return;
        }
        if (!(qs instanceof Number)) {
            return;
        }
        Number qsn = (Number)qs;
        for (CBRCase c : cases) {
            try {
                Object cs = AttributeUtils.findValue(source, c);
                CaseComponent cdcomp = AttributeUtils.findBelongingComponent(destination, c);
                Object cd = destination.getValue(cdcomp);
                if (cs == null || cd == null) {
                    return;
                }
                if (!(cs instanceof Number) || !(cd instanceof Number)) {
                    return;
                }
                Number csn = (Number)cs;
                Number cdn = (Number)cd;
                Double dres = cdn.doubleValue() / csn.doubleValue() * qsn.doubleValue();
                if (cd instanceof Double) {
                    destination.setValue(cdcomp, dres);
                    continue;
                }
                if (cd instanceof Integer) {
                    destination.setValue(cdcomp, new Integer(dres.intValue()));
                    continue;
                }
                if (cd instanceof Float) {
                    destination.setValue(cdcomp, new Float(dres.floatValue()));
                    continue;
                }
                if (cd instanceof Byte) {
                    destination.setValue(cdcomp, new Byte(dres.byteValue()));
                    continue;
                }
                if (!(cd instanceof Short)) continue;
                destination.setValue(cdcomp, new Short(dres.shortValue()));
            }
            catch (AttributeAccessException e) {
                LogFactory.getLog(NumericDirectProportionMethod.class).error((Object)e);
            }
        }
    }
}

