/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.retrieve.DiverseByMedianRetrieval;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.cbrcore.CaseComponent;
import jcolibri.method.retrieve.NNretrieval.NNConfig;
import jcolibri.method.retrieve.NNretrieval.NNScoringMethod;
import jcolibri.method.retrieve.RetrievalResult;
import jcolibri.util.AttributeUtils;
import jcolibri.util.CopyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpertClerkMedianScoring {
    public static Collection<RetrievalResult> getDiverseByMedian(Collection<CBRCase> cases, NNConfig simConfig, HashMap<Attribute, Double> thresholds) {
        CaseComponent median = ExpertClerkMedianScoring.calculateMedian(cases);
        CBRQuery query = new CBRQuery();
        query.setDescription(median);
        Collection<RetrievalResult> distancesToMedian = NNScoringMethod.evaluateSimilarity(cases, query, simConfig);
        CBRCase first = distancesToMedian.iterator().next().get_case();
        ArrayList<RetrievalResult> characteristics = new ArrayList<RetrievalResult>();
        double maxCharacteristics = AttributeUtils.getAttributes(cases.iterator().next().getDescription()).size();
        for (CBRCase _case : cases) {
            if (_case.equals(first)) continue;
            int chars = ExpertClerkMedianScoring.computeCharacteristics(_case, median, simConfig, thresholds);
            characteristics.add(new RetrievalResult(_case, (double)chars / maxCharacteristics));
        }
        characteristics.add(new RetrievalResult(first, 1.0));
        Collections.sort(characteristics);
        return characteristics;
    }

    private static int computeCharacteristics(CBRCase _case, CaseComponent median, NNConfig simConfig, HashMap<Attribute, Double> thresholds) {
        int characteristics = 0;
        for (Attribute at : AttributeUtils.getAttributes(_case.getDescription())) {
            Double threshold;
            double ad;
            double medV;
            double v;
            if (at.equals(_case.getDescription().getIdAttribute())) continue;
            Object value = AttributeUtils.findValue(at, _case.getDescription());
            Object medValue = AttributeUtils.findValue(at, median);
            if (value == null || medValue == null) continue;
            if (value instanceof Number) {
                v = ((Number)value).doubleValue();
                medV = ((Number)medValue).doubleValue();
                ad = simConfig.getWeight(at) * (v - medV);
                threshold = thresholds.get(at);
                if (threshold == null) {
                    threshold = 0.5;
                }
                if (!(Math.abs(ad) > threshold)) continue;
                ++characteristics;
                continue;
            }
            if (value instanceof Enum) {
                v = ((Enum)value).ordinal();
                medV = ((Enum)medValue).ordinal();
                ad = simConfig.getWeight(at) * (v - medV);
                threshold = thresholds.get(at);
                if (threshold == null) {
                    threshold = 1.0;
                }
                if (!(Math.abs(ad) > threshold)) continue;
                ++characteristics;
                continue;
            }
            if (value.equals(medValue)) continue;
            ++characteristics;
        }
        return characteristics;
    }

    private static CaseComponent calculateMedian(Collection<CBRCase> cases) {
        HashMap enumCount = new HashMap();
        HashMap<Attribute, Double> numValues = new HashMap<Attribute, Double>();
        for (CBRCase _case : cases) {
            for (Attribute at : AttributeUtils.getAttributes(_case.getDescription())) {
                Integer count;
                Object value;
                if (at.equals(_case.getDescription().getIdAttribute()) || (value = AttributeUtils.findValue(at, _case.getDescription())) == null) continue;
                if (value instanceof Number) {
                    Double sum = (Double)numValues.get(at);
                    if (sum == null) {
                        numValues.put(at, ((Number)value).doubleValue());
                        continue;
                    }
                    numValues.put(at, sum + ((Number)value).doubleValue());
                    continue;
                }
                HashMap<Object, Integer> enumValues = (HashMap<Object, Integer>)enumCount.get(at);
                if (enumValues == null) {
                    enumValues = new HashMap<Object, Integer>();
                    enumCount.put(at, enumValues);
                }
                if ((count = (Integer)enumValues.get(value)) == null) {
                    enumValues.put(value, new Integer(0));
                    continue;
                }
                enumValues.put(value, new Integer(count + 1));
            }
        }
        CaseComponent res = CopyUtils.copyCaseComponent(cases.iterator().next().getDescription());
        for (Attribute at : AttributeUtils.getAttributes(res)) {
            HashMap enumValues = (HashMap)enumCount.get(at);
            if (enumValues != null) {
                Object maxObject = null;
                int max = 0;
                for (Object value : enumValues.keySet()) {
                    Integer appears = (Integer)enumValues.get(value);
                    if (appears <= max) continue;
                    max = appears;
                    maxObject = value;
                }
                AttributeUtils.setValue(at, res, maxObject);
                continue;
            }
            Double sum = (Double)numValues.get(at);
            if (sum != null) {
                if (at.getType().equals(Integer.class)) {
                    AttributeUtils.setValue(at, res, (Object)((Number)(sum / (double)cases.size())).intValue());
                    continue;
                }
                if (at.getType().equals(Double.class)) {
                    AttributeUtils.setValue(at, res, (Object)(sum / (double)cases.size()));
                    continue;
                }
                if (at.getType().equals(Float.class)) {
                    AttributeUtils.setValue(at, res, (Object)Float.valueOf(((Number)(sum / (double)cases.size())).floatValue()));
                    continue;
                }
                if (at.getType().equals(Long.class)) {
                    AttributeUtils.setValue(at, res, (Object)((Number)(sum / (double)cases.size())).longValue());
                    continue;
                }
                if (!at.getType().equals(Short.class)) continue;
                AttributeUtils.setValue(at, res, (Object)((Number)(sum / (double)cases.size())).shortValue());
                continue;
            }
            AttributeUtils.setValue(at, res, null);
        }
        return res;
    }
}

