/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.retrieve.NNretrieval.similarity.local.recommenders;

import jcolibri.exception.NoApplicableSimilarityFunctionException;
import jcolibri.method.retrieve.NNretrieval.similarity.LocalSimilarityFunction;

public class InrecaMoreIsBetter
implements LocalSimilarityFunction {
    double jump;

    public InrecaMoreIsBetter(double jumpSimilarity) {
        this.jump = jumpSimilarity;
    }

    public double compute(Object caseObject, Object queryObject) throws NoApplicableSimilarityFunctionException {
        double queryValue;
        double caseValue;
        if (caseObject == null || queryObject == null) {
            return 0.0;
        }
        if (!(caseObject instanceof Number) && !(caseObject instanceof Enum)) {
            throw new NoApplicableSimilarityFunctionException(this.getClass(), caseObject.getClass());
        }
        if (!(queryObject instanceof Number) && !(queryObject instanceof Enum)) {
            throw new NoApplicableSimilarityFunctionException(this.getClass(), queryObject.getClass());
        }
        if (caseObject instanceof Number) {
            Number n1 = (Number)caseObject;
            Number n2 = (Number)queryObject;
            caseValue = n1.doubleValue();
            queryValue = n2.doubleValue();
        } else {
            Enum enum1 = (Enum)caseObject;
            Enum enum2 = (Enum)queryObject;
            caseValue = enum1.ordinal();
            queryValue = enum2.ordinal();
        }
        if (caseValue >= queryValue) {
            return 1.0;
        }
        return this.jump * (1.0 - (queryValue - caseValue) / queryValue);
    }

    public boolean isApplicable(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null) {
            return o2 instanceof Number || o2 instanceof Enum;
        }
        if (o2 == null) {
            return o1 instanceof Number || o1 instanceof Enum;
        }
        return o1 instanceof Number && o2 instanceof Number || o1 instanceof Enum && o2 instanceof Enum;
    }
}

