/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.test.test10;

import java.util.ArrayList;
import java.util.Collection;
import jcolibri.casebase.LinealCaseBase;
import jcolibri.cbraplications.StandardCBRApplication;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.cbrcore.Connector;
import jcolibri.connector.OntologyConnector;
import jcolibri.datatypes.Instance;
import jcolibri.exception.ExecutionException;
import jcolibri.exception.OntologyAccessException;
import jcolibri.method.retrieve.NNretrieval.NNConfig;
import jcolibri.method.retrieve.NNretrieval.NNScoringMethod;
import jcolibri.method.retrieve.NNretrieval.similarity.global.Average;
import jcolibri.method.retrieve.NNretrieval.similarity.local.Equal;
import jcolibri.method.retrieve.NNretrieval.similarity.local.ontology.OntCosine;
import jcolibri.method.retrieve.NNretrieval.similarity.local.ontology.OntDeep;
import jcolibri.method.retrieve.NNretrieval.similarity.local.ontology.OntDeepBasic;
import jcolibri.method.retrieve.NNretrieval.similarity.local.ontology.OntDetail;
import jcolibri.method.retrieve.RetrievalResult;
import jcolibri.method.retrieve.selection.SelectCases;
import jcolibri.test.test10.TravelDescription;
import jcolibri.util.CopyUtils;
import jcolibri.util.FileIO;

public class Test10
implements StandardCBRApplication {
    Connector _connector;
    CBRCaseBase _caseBase;

    public void configure() throws ExecutionException {
        try {
            this._connector = new OntologyConnector();
            this._connector.initFromXMLfile(FileIO.findFile("jcolibri/test/test10/ontologyconfig.xml"));
            this._caseBase = new LinealCaseBase();
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    public CBRCaseBase preCycle() throws ExecutionException {
        this._caseBase.init(this._connector);
        for (CBRCase c : this._caseBase.getCases()) {
            System.out.println(c);
        }
        return this._caseBase;
    }

    public void cycle(CBRQuery query) throws ExecutionException {
        NNConfig simConfig = new NNConfig();
        simConfig.setDescriptionSimFunction(new Average());
        simConfig.addMapping(new Attribute("Accommodation", TravelDescription.class), new OntCosine());
        simConfig.addMapping(new Attribute("Duration", TravelDescription.class), new OntDetail());
        simConfig.addMapping(new Attribute("HolidayType", TravelDescription.class), new OntDeep());
        simConfig.addMapping(new Attribute("NumberOfPersons", TravelDescription.class), new OntDeepBasic());
        simConfig.addMapping(new Attribute("Transportation", TravelDescription.class), new OntDeepBasic());
        simConfig.addMapping(new Attribute("Season", TravelDescription.class), new Equal());
        System.out.println("Query:");
        System.out.println(query);
        System.out.println();
        Collection<RetrievalResult> eval = NNScoringMethod.evaluateSimilarity(this._caseBase.getCases(), query, simConfig);
        eval = SelectCases.selectTopKRR(eval, 10);
        System.out.println("Retrieved cases:");
        for (RetrievalResult nse : eval) {
            System.out.println(nse);
        }
    }

    public void postCycle() throws ExecutionException {
        this._caseBase.close();
    }

    public static void main(String[] args) {
        try {
            OntologyConnector _connector = new OntologyConnector();
            _connector.initFromXMLfile(FileIO.findFile("jcolibri/test/test10/ontologyconfig.xml"));
            LinealCaseBase _caseBase = new LinealCaseBase();
            _caseBase.init(_connector);
            System.out.println("Loaded cases:");
            for (CBRCase c : _caseBase.getCases()) {
                System.out.println(c);
            }
            CBRCase aCase = _caseBase.getCases().iterator().next();
            aCase = CopyUtils.copyCBRCase(aCase);
            Instance newId = Instance.createInstance("newInstance", _connector.getCaseMainConcept());
            Attribute descriptionIdAttribute = aCase.getDescription().getIdAttribute();
            descriptionIdAttribute.setValue(aCase.getDescription(), newId);
            Attribute solutionIdAttribute = aCase.getSolution().getIdAttribute();
            solutionIdAttribute.setValue(aCase.getSolution(), newId);
            ArrayList<CBRCase> cases = new ArrayList<CBRCase>();
            cases.add(aCase);
            _connector.storeCases(cases);
            _connector.close();
            _connector = new OntologyConnector();
            _connector.initFromXMLfile(FileIO.findFile("jcolibri/test/test10/ontologyconfig.xml"));
            _caseBase = new LinealCaseBase();
            _caseBase.init(_connector);
            System.out.println("Loaded cases: (the new case should be there)");
            for (CBRCase c : _caseBase.getCases()) {
                System.out.println(c);
                if (!c.getID().toString().equals("newInstance")) continue;
                aCase = c;
            }
            cases.clear();
            cases.add(aCase);
            _caseBase.forgetCases(cases);
            _connector.close();
            Test10 test = new Test10();
            test.configure();
            test.preCycle();
            TravelDescription queryDesc = new TravelDescription();
            try {
                queryDesc.setAccommodation(new Instance("THREESTARS"));
                queryDesc.setDuration(new Instance("I10"));
                queryDesc.setHolidayType(new Instance("RECREATION"));
                queryDesc.setNumberOfPersons(new Instance("I4"));
                queryDesc.setSeason(new Instance("April"));
                queryDesc.setTransportation(new Instance("PLANE"));
            }
            catch (OntologyAccessException e) {
                throw new ExecutionException(e);
            }
            CBRQuery query = new CBRQuery();
            query.setDescription(queryDesc);
            test.cycle(query);
            test.postCycle();
        }
        catch (ExecutionException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

