/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.test.test5;

import es.ucm.fdi.gaia.ontobridge.OntoBridge;
import es.ucm.fdi.gaia.ontobridge.OntologyDocument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import jcolibri.casebase.LinealCaseBase;
import jcolibri.cbraplications.StandardCBRApplication;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.cbrcore.Connector;
import jcolibri.connector.DataBaseConnector;
import jcolibri.datatypes.Instance;
import jcolibri.exception.ExecutionException;
import jcolibri.exception.OntologyAccessException;
import jcolibri.method.retrieve.NNretrieval.NNConfig;
import jcolibri.method.retrieve.NNretrieval.NNScoringMethod;
import jcolibri.method.retrieve.NNretrieval.similarity.global.Average;
import jcolibri.method.retrieve.NNretrieval.similarity.local.Equal;
import jcolibri.method.retrieve.NNretrieval.similarity.local.Interval;
import jcolibri.method.retrieve.NNretrieval.similarity.local.ontology.OntCosine;
import jcolibri.method.retrieve.RetrievalResult;
import jcolibri.method.retrieve.selection.SelectCases;
import jcolibri.method.reuse.CombineQueryAndCasesMethod;
import jcolibri.method.reuse.NumericDirectProportionMethod;
import jcolibri.test.database.HSQLDBserver;
import jcolibri.test.test5.Region;
import jcolibri.test.test5.TravelDescription;
import jcolibri.test.test5.TravelSolution;
import jcolibri.util.FileIO;
import jcolibri.util.OntoBridgeSingleton;

public class Test5
implements StandardCBRApplication {
    Connector _connector;
    CBRCaseBase _caseBase;

    public void configure() throws ExecutionException {
        try {
            this._connector = new DataBaseConnector();
            this._connector.initFromXMLfile(FileIO.findFile("jcolibri/test/test5/databaseconfig.xml"));
            this._caseBase = new LinealCaseBase();
            OntoBridge ob = OntoBridgeSingleton.getOntoBridge();
            ob.initWithPelletReasoner();
            OntologyDocument mainOnto = new OntologyDocument("http://gaia.fdi.ucm.es/ontologies/vacation.owl", FileIO.findFile("jcolibri/test/test5/vacation.owl").toExternalForm());
            ArrayList subOntologies = new ArrayList();
            ob.loadOntology(mainOnto, subOntologies, false);
            System.out.println("Instances of SEASON");
            Iterator i = ob.listInstances("SEASON");
            while (i.hasNext()) {
                System.out.println((String)i.next());
            }
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    public CBRCaseBase preCycle() throws ExecutionException {
        this._caseBase.init(this._connector);
        for (CBRCase c : this._caseBase.getCases()) {
            System.out.println(c);
        }
        return this._caseBase;
    }

    public void cycle(CBRQuery query) throws ExecutionException {
        NNConfig simConfig = new NNConfig();
        simConfig.setDescriptionSimFunction(new Average());
        simConfig.addMapping(new Attribute("Accommodation", TravelDescription.class), new Equal());
        Attribute duration = new Attribute("Duration", TravelDescription.class);
        simConfig.addMapping(duration, new Interval(31.0));
        simConfig.setWeight(duration, 0.5);
        simConfig.addMapping(new Attribute("HolidayType", TravelDescription.class), new Equal());
        simConfig.addMapping(new Attribute("NumberOfPersons", TravelDescription.class), new Equal());
        simConfig.addMapping(new Attribute("Season", TravelDescription.class), new OntCosine());
        simConfig.addMapping(new Attribute("Region", TravelDescription.class), new Average());
        simConfig.addMapping(new Attribute("region", Region.class), new Equal());
        simConfig.addMapping(new Attribute("city", Region.class), new Equal());
        simConfig.addMapping(new Attribute("airport", Region.class), new Equal());
        simConfig.addMapping(new Attribute("currency", Region.class), new Equal());
        System.out.println("Query:");
        System.out.println(query);
        System.out.println();
        Collection<RetrievalResult> eval = NNScoringMethod.evaluateSimilarity(this._caseBase.getCases(), query, simConfig);
        Collection<CBRCase> selectedcases = SelectCases.selectTopK(eval, 1);
        NumericDirectProportionMethod.directProportion(new Attribute("NumberOfPersons", TravelDescription.class), new Attribute("price", TravelSolution.class), query, selectedcases);
        NumericDirectProportionMethod.directProportion(new Attribute("Duration", TravelDescription.class), new Attribute("price", TravelSolution.class), query, selectedcases);
        System.out.println("Retrieved cases:");
        for (RetrievalResult nse : eval) {
            System.out.println(nse);
        }
        System.out.println("Query:");
        System.out.println(query);
        Collection<CBRCase> newcases = CombineQueryAndCasesMethod.combine(query, selectedcases);
        System.out.println("Combined cases");
        for (CBRCase c : newcases) {
            System.out.println(c);
        }
    }

    public void postCycle() throws ExecutionException {
        this._caseBase.close();
    }

    public static void main(String[] args) {
        HSQLDBserver.init();
        Test5 test4 = new Test5();
        try {
            test4.configure();
            test4.preCycle();
            TravelDescription queryDesc = new TravelDescription();
            queryDesc.setAccommodation(TravelDescription.AccommodationTypes.ThreeStars);
            queryDesc.setDuration(10);
            queryDesc.setHolidayType("Recreation");
            queryDesc.setNumberOfPersons(4);
            try {
                queryDesc.setSeason(new Instance("April"));
            }
            catch (OntologyAccessException e) {
                throw new ExecutionException(e);
            }
            Region region = new Region();
            region.setRegion("Bulgaria");
            region.setCity("Sofia");
            region.setCurrency("Euro");
            region.setAirport("airport");
            queryDesc.setRegion(region);
            CBRQuery query = new CBRQuery();
            query.setDescription(queryDesc);
            test4.cycle(query);
            test4.postCycle();
            HSQLDBserver.shutDown();
        }
        catch (ExecutionException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

