/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.retrieve.NNretrieval.similarity.local.textual;

import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.datatypes.Text;
import jcolibri.exception.NoApplicableSimilarityFunctionException;
import jcolibri.extensions.textual.lucene.LuceneIndex;
import jcolibri.extensions.textual.lucene.LuceneSearchResult;
import jcolibri.extensions.textual.lucene.LuceneSearcher;
import jcolibri.method.retrieve.LuceneRetrieval.LuceneRetrieval;
import jcolibri.method.retrieve.NNretrieval.similarity.InContextLocalSimilarityFunction;
import jcolibri.util.AttributeUtils;
import org.apache.commons.logging.LogFactory;

public class LuceneTextSimilarity
extends InContextLocalSimilarityFunction {
    LuceneSearchResult lsr = null;
    boolean normalized = false;

    public LuceneTextSimilarity(LuceneIndex index, CBRQuery query, Attribute at, boolean normalized) {
        this.normalized = normalized;
        Object queryString = AttributeUtils.findValue(at, query);
        if (!(queryString instanceof Text)) {
            LogFactory.getLog(LuceneRetrieval.class).error((Object)"Search field has not a Text value. Returning empty RetrievalResult list.");
            return;
        }
        Text qs = (Text)queryString;
        String sf = at.getName();
        this.lsr = LuceneSearcher.search(index, qs.toString(), sf);
    }

    public double compute(Object caseObject, Object queryObject) throws NoApplicableSimilarityFunctionException {
        if (caseObject == null || queryObject == null) {
            return 0.0;
        }
        if (!(caseObject instanceof Text)) {
            throw new NoApplicableSimilarityFunctionException(this.getClass(), caseObject.getClass());
        }
        if (!(queryObject instanceof Text)) {
            throw new NoApplicableSimilarityFunctionException(this.getClass(), queryObject.getClass());
        }
        return this.lsr.getDocScore(this._case.getID().toString(), this.normalized);
    }

    public boolean isApplicable(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null) {
            return o2 instanceof Text;
        }
        if (o2 == null) {
            return o1 instanceof Text;
        }
        return o1 instanceof Text && o2 instanceof Text;
    }
}

