/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.test.test7;

import java.util.Collection;
import jcolibri.casebase.LinealCaseBase;
import jcolibri.cbraplications.StandardCBRApplication;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.cbrcore.Connector;
import jcolibri.connector.PlainTextConnector;
import jcolibri.exception.ExecutionException;
import jcolibri.method.maintenance.algorithms.ICFFull;
import jcolibri.method.maintenance.algorithms.ICFRedundancyRemoval;
import jcolibri.method.maintenance.algorithms.RENNNoiseReduction;
import jcolibri.method.retrieve.NNretrieval.similarity.global.Average;
import jcolibri.method.retrieve.NNretrieval.similarity.local.Interval;
import jcolibri.method.reuse.classification.KNNClassificationConfig;
import jcolibri.method.reuse.classification.SimilarityWeightedVotingMethod;
import jcolibri.test.main.SwingProgressBar;
import jcolibri.test.test7.IrisDescription;
import jcolibri.util.FileIO;
import jcolibri.util.ProgressController;
import org.apache.commons.logging.LogFactory;

public class Test7
implements StandardCBRApplication {
    Connector _connector;
    CBRCaseBase _caseBase;

    public void configure() throws ExecutionException {
        try {
            this._connector = new PlainTextConnector();
            this._connector.initFromXMLfile(FileIO.findFile("jcolibri/test/test7/plaintextconfig.xml"));
            this._caseBase = new LinealCaseBase();
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    public CBRCaseBase preCycle() throws ExecutionException {
        this._caseBase.init(this._connector);
        return this._caseBase;
    }

    public void cycle(CBRQuery q) throws ExecutionException {
        KNNClassificationConfig irisSimConfig = new KNNClassificationConfig();
        irisSimConfig.setDescriptionSimFunction(new Average());
        irisSimConfig.addMapping(new Attribute("sepalLength", IrisDescription.class), new Interval(3.6));
        irisSimConfig.addMapping(new Attribute("sepalWidth", IrisDescription.class), new Interval(2.4));
        irisSimConfig.addMapping(new Attribute("petalLength", IrisDescription.class), new Interval(5.9));
        irisSimConfig.addMapping(new Attribute("petalWidth", IrisDescription.class), new Interval(2.4));
        irisSimConfig.setClassificationMethod(new SimilarityWeightedVotingMethod());
        irisSimConfig.setK(3);
        ICFFull edit = new ICFFull(new RENNNoiseReduction(), new ICFRedundancyRemoval());
        Collection<CBRCase> deleted = edit.retrieveCasesToDelete(this._caseBase.getCases(), irisSimConfig);
        System.out.println();
        System.out.println("Num Cases deleted by Alg: " + deleted.size());
        System.out.println("Cases deleted by Alg: ");
        for (CBRCase c : deleted) {
            System.out.println(c.getID());
        }
    }

    public void postCycle() throws ExecutionException {
        this._connector.close();
    }

    public static void main(String[] args) {
        Test7 test = new Test7();
        ProgressController.clear();
        ProgressController.register(new SwingProgressBar(), RENNNoiseReduction.class);
        ProgressController.register(new SwingProgressBar(), ICFRedundancyRemoval.class);
        try {
            test.configure();
            test.preCycle();
            test.cycle(null);
        }
        catch (ExecutionException e) {
            LogFactory.getLog(Test7.class).error((Object)e);
        }
    }
}

