/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.textual.IE.representation;

import java.util.ArrayList;
import java.util.List;
import jcolibri.datatypes.Text;
import jcolibri.extensions.textual.IE.representation.Paragraph;
import jcolibri.extensions.textual.IE.representation.Sentence;
import jcolibri.extensions.textual.IE.representation.Token;
import jcolibri.extensions.textual.IE.representation.info.FeatureInfo;
import jcolibri.extensions.textual.IE.representation.info.PhraseInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IEText
extends Text {
    protected List<Paragraph> paragraphs = new ArrayList<Paragraph>();
    protected List<PhraseInfo> phrases = new ArrayList<PhraseInfo>();
    protected List<FeatureInfo> features = new ArrayList<FeatureInfo>();
    protected List<String> topics = new ArrayList<String>();

    public IEText() {
    }

    public IEText(String content) {
        super(content);
    }

    public String getRAWContent() {
        return this.rawContent;
    }

    public String printAnnotations() {
        StringBuffer sb = new StringBuffer();
        for (Paragraph par : this.paragraphs) {
            sb.append(par.toString());
        }
        return String.valueOf(sb.toString()) + "\nPHRASES: " + this.phrases.toString() + "\nFEATURES: " + this.features.toString();
    }

    public List<FeatureInfo> getFeatures() {
        return this.features;
    }

    public void addFeatures(List<FeatureInfo> features) {
        features.addAll(features);
    }

    public void addFeature(FeatureInfo feature) {
        this.features.add(feature);
    }

    public List<Paragraph> getParagraphs() {
        return this.paragraphs;
    }

    public void addParagraphs(List<Paragraph> paragraphs) {
        this.paragraphs.addAll(paragraphs);
    }

    public void addParagraph(Paragraph paragraph) {
        this.paragraphs.add(paragraph);
    }

    public List<PhraseInfo> getPhrases() {
        return this.phrases;
    }

    public void addPhrases(List<PhraseInfo> phrases) {
        this.phrases.addAll(phrases);
    }

    public void addPhrase(PhraseInfo phrase) {
        this.phrases.add(phrase);
    }

    public List<String> getTopics() {
        return this.topics;
    }

    public void addTopics(List<String> topics) {
        this.topics.addAll(topics);
    }

    public void addTopic(String topics) {
        this.topics.add(topics);
    }

    public List<Sentence> getAllSentences() {
        ArrayList<Sentence> sentences = new ArrayList<Sentence>();
        for (Paragraph p : this.paragraphs) {
            sentences.addAll(p.getSentences());
        }
        return sentences;
    }

    public List<Token> getAllTokens() {
        ArrayList<Token> tokens = new ArrayList<Token>();
        for (Paragraph p : this.paragraphs) {
            for (Sentence s : p.getSentences()) {
                tokens.addAll(s.getTokens());
            }
        }
        return tokens;
    }
}

