/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.retrieve.FilterBasedRetrieval;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.cbrcore.CaseComponent;
import jcolibri.method.retrieve.FilterBasedRetrieval.FilterConfig;
import jcolibri.method.retrieve.FilterBasedRetrieval.predicates.FilterPredicate;
import jcolibri.util.AttributeUtils;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterBasedRetrievalMethod {
    public static Collection<CBRCase> filterCases(Collection<CBRCase> cases, CBRQuery query, FilterConfig filterConfig) {
        if (filterConfig == null) {
            return cases;
        }
        ArrayList<CBRCase> res = new ArrayList<CBRCase>();
        for (CBRCase c : cases) {
            if (!FilterBasedRetrievalMethod.filter(c.getDescription(), query.getDescription(), filterConfig)) continue;
            res.add(c);
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean filter(CaseComponent cc, CaseComponent qc, FilterConfig config) {
        try {
            FilterPredicate predicate;
            Attribute att;
            Iterator<Attribute> iterator = AttributeUtils.getAttributes(cc).iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while (!(CaseComponent.class.isAssignableFrom((att = iterator.next()).getType()) ? !FilterBasedRetrievalMethod.filter((CaseComponent)att.getValue(cc), (CaseComponent)att.getValue(qc), config) : !att.equals(cc.getIdAttribute()) && (predicate = config.getPredicate(att)) != null && !predicate.compute(att.getValue(cc), att.getValue(qc))));
            return false;
        }
        catch (Exception e) {
            LogFactory.getLog(FilterBasedRetrievalMethod.class).error((Object)e);
            return false;
        }
    }
}

