/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.retrieve.NNretrieval.similarity.local.textual;

import java.util.Collection;
import java.util.Set;
import jcolibri.extensions.textual.IE.representation.Token;
import jcolibri.extensions.textual.IE.representation.info.WeightedRelation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextualSimUtils {
    public static void expandTokensSet(Collection<Token> caseTokens, Collection<Token> queryToken, Set<WeightedString> caseSet, Set<WeightedString> querySet) {
        caseSet.clear();
        querySet.clear();
        for (Token qTok : queryToken) {
            if (qTok.isStopWord()) continue;
            for (WeightedRelation rel : qTok.getRelations()) {
                Token destToken = rel.getDestination();
                if (!caseTokens.contains(destToken)) continue;
                String newStem = String.valueOf(qTok.getStem()) + "_RELATED_" + destToken.getStem();
                WeightedString ws = new WeightedString(newStem, rel.getWeight());
                caseSet.add(ws);
                querySet.add(ws);
            }
            querySet.add(new WeightedString(qTok.getStem(), 1.0));
        }
        for (Token cTok : caseTokens) {
            if (cTok.isStopWord()) continue;
            caseSet.add(new WeightedString(cTok.getStem(), 1.0));
        }
    }

    public static double getSize(Collection<WeightedString> col) {
        double res = 0.0;
        for (WeightedString ws : col) {
            res += ws.getWeight();
        }
        return res;
    }

    public static class WeightedString {
        String string;
        double weight;

        public WeightedString(String string, double weight) {
            this.string = string;
            this.weight = weight;
        }

        public String getString() {
            return this.string;
        }

        public double getWeight() {
            return this.weight;
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof WeightedString)) {
                return false;
            }
            WeightedString ws = (WeightedString)o;
            return this.string.equals(ws.getString());
        }
    }
}

