/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.maintenance.algorithms;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import jcolibri.cbrcore.CBRCase;
import jcolibri.method.maintenance.AbstractCaseBaseEditMethod;
import jcolibri.method.maintenance.CompetenceModel;
import jcolibri.method.maintenance.solvesFunctions.ICFSolvesFunction;
import jcolibri.method.reuse.classification.KNNClassificationConfig;
import jcolibri.util.ProgressController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICFRedundancyRemoval
extends AbstractCaseBaseEditMethod {
    @Override
    public Collection<CBRCase> retrieveCasesToDelete(Collection<CBRCase> cases, KNNClassificationConfig simConfig) {
        ProgressController.init(this.getClass(), "ICF Redundancy Removal", -1);
        LinkedList<CBRCase> localCases = new LinkedList<CBRCase>();
        for (CBRCase c : cases) {
            localCases.add(c);
        }
        CompetenceModel sc = new CompetenceModel();
        Map<CBRCase, Collection<CBRCase>> coverageSets = null;
        Map<CBRCase, Collection<CBRCase>> reachabilitySets = null;
        LinkedList<CBRCase> allCasesToBeRemoved = new LinkedList<CBRCase>();
        boolean changes = true;
        while (changes) {
            changes = false;
            LinkedList<CBRCase> casesToBeRemoved = new LinkedList<CBRCase>();
            sc.computeCompetenceModel(new ICFSolvesFunction(), simConfig, localCases);
            coverageSets = sc.getCoverageSets();
            reachabilitySets = sc.getReachabilitySets();
            for (CBRCase c : localCases) {
                Collection<CBRCase> coverageSet = coverageSets.get(c);
                Collection<CBRCase> reachabilitySet = reachabilitySets.get(c);
                if (reachabilitySet.size() <= coverageSet.size()) continue;
                casesToBeRemoved.add(c);
                changes = true;
            }
            allCasesToBeRemoved.addAll(casesToBeRemoved);
            localCases.removeAll(casesToBeRemoved);
            ProgressController.step(this.getClass());
        }
        ProgressController.finish(this.getClass());
        return allCasesToBeRemoved;
    }
}

