package it.unimi.di.laren.sndapp.view;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

import it.unimi.di.laren.sndapp.R;
import it.unimi.di.laren.sndapp.controller.Main_Controller;
import android.os.Build;
import android.os.Bundle;
import android.os.StrictMode;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ProgressDialog;
import android.util.Log;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;

@TargetApi(Build.VERSION_CODES.GINGERBREAD)
@SuppressLint("NewApi")
public class MainActivity extends Activity {
	public Spinner spinner;
	public Button login;
	public String user;
	public String pwd;
	public EditText pass;
	public ProgressDialog pDialog = null;

	@TargetApi(Build.VERSION_CODES.GINGERBREAD)
	@SuppressLint("NewApi")
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		StrictMode.ThreadPolicy policy = new StrictMode.ThreadPolicy.Builder().permitAll().build();
		StrictMode.setThreadPolicy(policy);
		spinner = (Spinner) findViewById(R.id.user_spinner);
		login = (Button) findViewById(R.id.butt);
		pass = (EditText)findViewById(R.id.passET);
		// Create an ArrayAdapter using the string array and a default spinner layout
		ArrayAdapter<CharSequence> adapter = ArrayAdapter.createFromResource(this,
				R.array.users_array, android.R.layout.simple_spinner_item);
		// Specify the layout to use when the list of choices appears
		adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
		// Apply the adapter to the spinner
		spinner.setAdapter(adapter);
		Main_Controller controller = new Main_Controller(this);
		login.setOnClickListener(controller);
		pDialog = new ProgressDialog(MainActivity.this);
	}
	//HTTP CONNECTION
	private InputStream openHttpConnection(String urlString) throws IOException {
		InputStream in = null;
		int response = -1;
		URL url = new URL(urlString);
		URLConnection conn = url.openConnection();
		if (!(conn instanceof HttpURLConnection)){
			Log.i("UrlInvalid", ":" + conn);
			throw new IOException("Not an HTTP connection");
		}
		try {
			HttpURLConnection httpConn = (HttpURLConnection) conn;

			Log.i("Step1", ":" + httpConn);
			httpConn.setDoInput(true);
			Log.i("Step2", ":" + httpConn);
			httpConn.connect();
			Log.i("Step3", ":" + httpConn);
			response = httpConn.getResponseCode();
			Log.i("Step4", ":" + httpConn);
			if (response == HttpURLConnection.HTTP_OK) {
				Log.i("Step5", ":" + httpConn);
				in = httpConn.getInputStream();
			}
		} catch (Exception ex) {   
			Log.i("Step6", ":" + ex);
			throw new IOException("Error connecting");
		}
		return in;
	}


	//SEND LOGIN
	public String sendStatusCommand(String device, String psw, String value){
		byte[] contents = new byte[1024];
		int bytesRead = 0;
		String result = "null";
		try {
			String format = getString(R.string.urls);
			String url = String.format(format, device, psw, value);
			Log.i("URL", ":" + url);
			InputStream inputstream = openHttpConnection(url);
			Log.i("Inputstream", ":" + inputstream);
			InputStream in = new BufferedInputStream(inputstream);
			if((bytesRead = in.read(contents)) != -1){
				result = new String(contents, 0, bytesRead);
			}
			in.close();
			inputstream.close();
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
			Log.i("eccez",e.getMessage());
		}
		return result;
	}
}
