package it.unimi.di.laren.sndapp.view;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

import it.unimi.di.laren.sndapp.R;
import it.unimi.di.laren.sndapp.R.layout;
import it.unimi.di.laren.sndapp.R.menu;
import it.unimi.di.laren.sndapp.controller.WasherControl_Controller;
import android.os.Build;
import android.os.Bundle;
import android.os.StrictMode;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.util.Log;
import android.view.Menu;
import android.widget.Button;
import android.widget.TextView;

@TargetApi(Build.VERSION_CODES.GINGERBREAD)
@SuppressLint("NewApi")
public class WasherControlActivity extends Activity {

	public Button waterz, waterv, waterc, waters, wateroff, temptre, tempqua, tempses, tempnov, tempoff, spindcw, spinscw, spinoffcw, spindccw, spinsccw, spinoffccw;
	public Button lock, unlock;
	
	public TextView command;
	public String user, pass;

	@TargetApi(Build.VERSION_CODES.GINGERBREAD)
	@SuppressLint("NewApi")
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.washer_activity_control);
		StrictMode.ThreadPolicy policy = new StrictMode.ThreadPolicy.Builder().permitAll().build();
		StrictMode.setThreadPolicy(policy);
		WasherControl_Controller controller = new WasherControl_Controller(this);
		command = (TextView)findViewById(R.id.commandTxt);
		waterz = (Button)findViewById(R.id.btn1);
		waterv = (Button)findViewById(R.id.btn2);
		waterc = (Button)findViewById(R.id.btn3);
		waters = (Button)findViewById(R.id.btn4);
		wateroff = (Button)findViewById(R.id.btno1);
		temptre = (Button)findViewById(R.id.btn1t);
		tempqua = (Button)findViewById(R.id.btn2t);
		tempses = (Button)findViewById(R.id.btn3t);
		tempnov = (Button)findViewById(R.id.btn4t);
		tempoff = (Button)findViewById(R.id.btn5t);
		spindcw = (Button)findViewById(R.id.btn1s);
		spinscw = (Button)findViewById(R.id.btn2s);
		spinoffcw = (Button)findViewById(R.id.btn3s);
		spindccw = (Button)findViewById(R.id.btn1sc);
		spinsccw = (Button)findViewById(R.id.btn2sc);
		spinoffccw = (Button)findViewById(R.id.btn3sc);
		lock = (Button)findViewById(R.id.btnl1);
		unlock = (Button)findViewById(R.id.btnl2);
		waterz.setOnClickListener(controller);
		waterv.setOnClickListener(controller);
		waterc.setOnClickListener(controller);
		waters.setOnClickListener(controller);
		wateroff.setOnClickListener(controller);
		temptre.setOnClickListener(controller);
		tempqua.setOnClickListener(controller);
		tempses.setOnClickListener(controller);
		tempnov.setOnClickListener(controller);
		tempoff.setOnClickListener(controller);
		spindcw.setOnClickListener(controller);
		spinscw.setOnClickListener(controller);
		spinoffcw.setOnClickListener(controller);
		spindccw.setOnClickListener(controller);
		spinsccw.setOnClickListener(controller);
		spinoffccw.setOnClickListener(controller);
		lock.setOnClickListener(controller);
		unlock.setOnClickListener(controller);

		Bundle extras = getIntent().getExtras();
		if (extras == null) {
			return;
		}
		else
		{
			user = extras.getString("USR");
			pass = extras.getString("PWD");
		}
	}
	//HTTP CONNECTION
	private InputStream openHttpConnection(String urlString) throws IOException {
		InputStream in = null;
		int response = -1;
		URL url = new URL(urlString);
		URLConnection conn = url.openConnection();
		if (!(conn instanceof HttpURLConnection)){
			Log.i("UrlInvalid", ":" + conn);
			throw new IOException("Not an HTTP connection");
		}
		try {
			HttpURLConnection httpConn = (HttpURLConnection) conn;

			Log.i("Step1", ":" + httpConn);
			httpConn.setDoInput(true);
			Log.i("Step2", ":" + httpConn);
			httpConn.connect();
			Log.i("Step3", ":" + httpConn);
			response = httpConn.getResponseCode();
			Log.i("Step4", ":" + httpConn);
			if (response == HttpURLConnection.HTTP_OK) {
				Log.i("Step5", ":" + httpConn);
				in = httpConn.getInputStream();
			}
		} catch (Exception ex) {   
			Log.i("Step6", ":" + ex);
			throw new IOException("Error connecting");
		}
		return in;
	}


	//SEND COMMAND
	public String sendStatusCommand(String device, String pwd, String cmd){
		byte[] contents = new byte[1024];
		int bytesRead = 0;
		String result = "null";
		try {
			String format = getString(R.string.urls);
			String url = String.format(format, device, pwd, cmd);
			Log.i("URL", ":" + url);
			InputStream inputstream = openHttpConnection(url);
			Log.i("Inputstream", ":" + inputstream);
			InputStream in = new BufferedInputStream(inputstream);
			if((bytesRead = in.read(contents)) != -1){
				result = new String(contents, 0, bytesRead);
			}
			in.close();
			inputstream.close();
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
			Log.i("eccez",e.getMessage());
		}
		return result;
	}


}
