package it.unimi.di.laren.sndapp.view;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

import it.unimi.di.laren.sndapp.R;
import it.unimi.di.laren.sndapp.controller.WasherSelection_Controller;
import android.os.Build;
import android.os.Bundle;
import android.os.StrictMode;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.util.Log;
import android.view.Menu;
import android.widget.Button;

@TargetApi(Build.VERSION_CODES.GINGERBREAD)
@SuppressLint("NewApi")
public class WasherSelectionActivity extends Activity {
	public String user, pass;

	public Button white, color, delic, cotton, synth;

	@TargetApi(Build.VERSION_CODES.GINGERBREAD)
	@SuppressLint("NewApi")
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.washer_activity_selection);
		StrictMode.ThreadPolicy policy = new StrictMode.ThreadPolicy.Builder().permitAll().build();
		StrictMode.setThreadPolicy(policy);
		white = (Button)findViewById(R.id.whitesBtn);
		color = (Button)findViewById(R.id.colorsBtn);
		delic = (Button)findViewById(R.id.delicatesBtn);
		cotton = (Button)findViewById(R.id.cottonsBtn);
		synth = (Button)findViewById(R.id.synthsBtn);
		WasherSelection_Controller controller = new WasherSelection_Controller(this);
		white.setOnClickListener(controller);
		color.setOnClickListener(controller);
		delic.setOnClickListener(controller);
		cotton.setOnClickListener(controller);
		synth.setOnClickListener(controller);
		Bundle extras = getIntent().getExtras();

		if (extras == null) {
			return;
		}
		else
		{
			user = extras.getString("USR");
			pass = extras.getString("PWD");
		}
	}
	//HTTP CONNECTION
	private InputStream openHttpConnection(String urlString) throws IOException {
		InputStream in = null;
		int response = -1;
		URL url = new URL(urlString);
		URLConnection conn = url.openConnection();
		if (!(conn instanceof HttpURLConnection)){
			Log.i("UrlInvalid", ":" + conn);
			throw new IOException("Not an HTTP connection");
		}
		try {
			HttpURLConnection httpConn = (HttpURLConnection) conn;

			Log.i("Step1", ":" + httpConn);
			httpConn.setDoInput(true);
			Log.i("Step2", ":" + httpConn);
			httpConn.connect();
			Log.i("Step3", ":" + httpConn);
			response = httpConn.getResponseCode();
			Log.i("Step4", ":" + httpConn);
			if (response == HttpURLConnection.HTTP_OK) {
				Log.i("Step5", ":" + httpConn);
				in = httpConn.getInputStream();
			}
		} catch (Exception ex) {   
			Log.i("Step6", ":" + ex);
			throw new IOException("Error connecting");
		}
		return in;
	}


	//SEND COMMAND
	public String sendStatusCommand(String device, String pwd, String cmd, String value){
		byte[] contents = new byte[1024];
		int bytesRead = 0;
		String result = "null";
		try {
			String format = getString(R.string.urlplay);
			String url = String.format(format, device, pwd, cmd, value);
			Log.i("URL", ":" + url);
			InputStream inputstream = openHttpConnection(url);
			Log.i("Inputstream", ":" + inputstream);
			InputStream in = new BufferedInputStream(inputstream);
			if((bytesRead = in.read(contents)) != -1){
				result = new String(contents, 0, bytesRead);
			}
			in.close();
			inputstream.close();
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
			Log.i("eccez",e.getMessage());
		}
		return result;
	}
}
