package it.unimi.di.laren.sndapp.view;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Timer;
import java.util.TimerTask;

import it.unimi.di.laren.sndapp.R;
import it.unimi.di.laren.sndapp.controller.BreadRecipe_Controller;
import android.os.Build;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.StrictMode;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.util.Log;
import android.view.Menu;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

@SuppressLint("NewApi")
@TargetApi(Build.VERSION_CODES.GINGERBREAD)
public class BreadRecipeActivity extends Activity{
	public Button next, play, stop, direct;
	public TextView timer;
	public boolean runs;
	public long oldtime = 0;
	public long time;
	public int a = 0;
	public TextView fase;
	public String label, msg, state, recipe, device;
	public CountDownTimer waitTimer;

	public String user, pass;
	private Timer myTimer;

	@TargetApi(Build.VERSION_CODES.GINGERBREAD)
	@SuppressLint("NewApi")
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.bread_activity_recipe);
		StrictMode.ThreadPolicy policy = new StrictMode.ThreadPolicy.Builder().permitAll().build();
		StrictMode.setThreadPolicy(policy);
		next = (Button)findViewById(R.id.nextBtn);
		play = (Button)findViewById(R.id.startBtn);
		stop = (Button)findViewById(R.id.stopBtn);
		timer = (TextView) findViewById(R.id.timeTxt);
		fase = (TextView)findViewById(R.id.faseTxt);
		direct = (Button)findViewById(R.id.directBtn);
		BreadRecipe_Controller controller = new BreadRecipe_Controller(this);
		next.setOnClickListener(controller);
		play.setOnClickListener(controller);
		stop.setOnClickListener(controller);
		direct.setOnClickListener(controller);

		runs = true;

		myTimer = new Timer();
		myTimer.schedule(new TimerTask() {			
			@Override
			public void run() {
					TimerMethod();
			}

		}, 0, 5000);
		

		Bundle extras = getIntent().getExtras();
		if (extras == null) {
			return;
		}
		else
		{
			user = extras.getString("USR");
			pass = extras.getString("PWD");
		}


		next.setVisibility(View.GONE);
		//wcommand("state");

	}

	public String timeCalculate(long ttime)   
	{  
		long  hoursuuu, minutesuuu, secondsuuu;  
		String restT = "";  

		hoursuuu = (Math.round(ttime) / 3600);  
		minutesuuu = (Math.round(ttime) / 60) - (hoursuuu * 60);  
		secondsuuu = Math.round(ttime) % 60;  

		restT = String.format("%02d:%02d:%02d", hoursuuu, minutesuuu, secondsuuu);  

		return restT;  
	}  

	//HTTP CONNECTION
	private InputStream openHttpConnection(String urlString) throws IOException {
		InputStream in = null;
		int response = -1;
		URL url = new URL(urlString);
		URLConnection conn = url.openConnection();
		if (!(conn instanceof HttpURLConnection)){
			Log.i("UrlInvalid", ":" + conn);
			throw new IOException("Not an HTTP connection");
		}
		try {
			HttpURLConnection httpConn = (HttpURLConnection) conn;

			Log.i("Step1", ":" + httpConn);
			httpConn.setDoInput(true);
			Log.i("Step2", ":" + httpConn);
			httpConn.connect();
			Log.i("Step3", ":" + httpConn);
			response = httpConn.getResponseCode();
			Log.i("Step4", ":" + httpConn);
			if (response == HttpURLConnection.HTTP_OK) {
				Log.i("Step5", ":" + httpConn);
				in = httpConn.getInputStream();
			}
		} catch (Exception ex) {   
			Log.i("Step6", ":" + ex);
			throw new IOException("Error connecting");
		}
		return in;
	}

	//SEND COMMAND
	public String sendStatusCommand2(String device, String pwd, String value){
		byte[] contents = new byte[1024];
		int bytesRead = 0;
		String result = "null";
		try {
			String format = getString(R.string.urls);
			String url = String.format(format, device, pwd, value);
			Log.i("URL", ":" + url);
			InputStream inputstream = openHttpConnection(url);
			Log.i("Inputstream", ":" + inputstream);
			InputStream in = new BufferedInputStream(inputstream);
			if((bytesRead = in.read(contents)) != -1){
				result = new String(contents, 0, bytesRead);
			}
			in.close();
			inputstream.close();
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
			Log.i("eccez",e.getMessage());
		}
		return result;
	}

	public String command(String st){
		msg = sendStatusCommand2(user, pass, st);
		String[] strArray = msg.split("/");
		for (String str : strArray) {
			Log.i("msg", ": "+ str);
		}

		device = strArray[0];
		recipe = strArray[1];
		state = strArray[2];
		label = strArray[3];
		time = Long.parseLong(strArray[4]);
		fase.setText(label);
		time = time*1000;
		timer.setText(timeCalculate(time/1000));

		if(state.equals("run")){
			play.setBackgroundResource(R.drawable.buttpausa);
			//waitTimer.start();
		}
		else if(state.equals("pause")){
			//waitTimer.start();
			//waitTimer.cancel();
		}
		else if (state.equals("stop")){
			next.setVisibility(View.VISIBLE);
		}
		//Log.i("device", ": "+ device);
		return device;
	}

	private void TimerMethod()
	{
		//This method is called directly by the timer
		//and runs in the same thread as the timer.

		//We call the method that will work with the UI
		//through the runOnUiThread method.
		this.runOnUiThread(Timer_Tick);
	}


	private Runnable Timer_Tick = new Runnable() {
		public void run() {

			//This method runs in the same thread as the UI.    	       

			//Do something to the UI thread here
			command("state");
			Log.i("INTERO", ": "+ a);
			a++;
		}
	};
}
