package it.unimi.di.laren.sndapp.view;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

import it.unimi.di.laren.sndapp.R;
import it.unimi.di.laren.sndapp.controller.DishFeedback_Controller;
import it.unimi.di.laren.sndapp.model.ImageAdapter;
import android.os.Build;
import android.os.Bundle;
import android.os.StrictMode;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.util.Log;
import android.view.Menu;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.AdapterView.OnItemClickListener;

@TargetApi(Build.VERSION_CODES.GINGERBREAD)
@SuppressLint("NewApi")
public class DishFeedbackActivity extends Activity {

	public Button send, btn1, btn2, btn3, btn4;
	public RelativeLayout rl2, rl3, rl4, rl5;
	public String dura = "2";
	public String clean = "2";
	public String dry = "2";
	public String load = "2";
	
	public String user, pass, type;

	public ListView lv2 = null;
	public ListView lv3 = null;
	public ListView lv4 = null;
	public ListView lv5 = null;
	private String s2[] = {"Bad", "Better", "Neutral", "Good", "Optimum"};
	private String s3[] = {"Bad", "Better", "Neutral", "Good", "Optimum"};
	private String s4[] = {"Bad", "Better", "Neutral", "Good", "Optimum"};
	private String s5[] = {"Bad", "Better", "Neutral", "Good", "Optimum"};

	@TargetApi(Build.VERSION_CODES.GINGERBREAD)
	@SuppressLint("NewApi")
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.dish_activity_feedback);
		StrictMode.ThreadPolicy policy = new StrictMode.ThreadPolicy.Builder().permitAll().build();
		StrictMode.setThreadPolicy(policy);
		send = (Button)findViewById(R.id.sendBtn);
		//send.setOnClickListener(controller);
		DishFeedback_Controller controller = new DishFeedback_Controller(this);
		btn1 = (Button)findViewById(R.id.btn1);
        btn2 = (Button)findViewById(R.id.btn2);
        btn3 = (Button)findViewById(R.id.btn3);
        btn4 = (Button)findViewById(R.id.btn4);
        btn1.setOnClickListener(controller);
        btn2.setOnClickListener(controller);
        btn3.setOnClickListener(controller);
        btn4.setOnClickListener(controller);
        
        
        rl2 = (RelativeLayout)findViewById(R.id.rl_ListView2);
        rl3 = (RelativeLayout)findViewById(R.id.rl_ListView3); 
        rl4 = (RelativeLayout)findViewById(R.id.rl_ListView4);
        rl5 = (RelativeLayout)findViewById(R.id.rl_ListView5); 
        lv2 = (ListView) findViewById (R.id.lv2);
        lv3 = (ListView) findViewById (R.id.lv3);
        lv4 = (ListView) findViewById (R.id.lv4);
        lv5 = (ListView) findViewById (R.id.lv5);
        

		lv2.setAdapter(new ArrayAdapter<String>(this,android.R.layout.simple_list_item_single_choice ,s2));
		lv2.setOnItemClickListener(new OnItemClickListener() {

			public void onItemClick(AdapterView<?> a, View v, int position, long id)
			{
				dura = String.valueOf(position);
			}
		});
		
		lv3.setAdapter(new ArrayAdapter<String>(this,android.R.layout.simple_list_item_single_choice ,s3));
		lv3.setOnItemClickListener(new OnItemClickListener() {

			public void onItemClick(AdapterView<?> a, View v, int position, long id)
			{
				clean = String.valueOf(position);
			}
		});
		
		lv4.setAdapter(new ArrayAdapter<String>(this,android.R.layout.simple_list_item_single_choice ,s4));
		lv4.setOnItemClickListener(new OnItemClickListener() {

			public void onItemClick(AdapterView<?> a, View v, int position, long id)
			{
				dry = String.valueOf(position);
			}
		});
		
		lv5.setAdapter(new ArrayAdapter<String>(this,android.R.layout.simple_list_item_single_choice ,s5));
		lv5.setOnItemClickListener(new OnItemClickListener() {

			public void onItemClick(AdapterView<?> a, View v, int position, long id)
			{
				load = String.valueOf(position);
			}
		});
		
		Bundle extras = getIntent().getExtras();
		if (extras == null) {
			return;
		}
		else
		{
			user = extras.getString("USR");
			pass = extras.getString("PWD");
			type = extras.getString("TYPE");
		}
	}
	//HTTP CONNECTION
			private InputStream openHttpConnection(String urlString) throws IOException {
				InputStream in = null;
				int response = -1;
				URL url = new URL(urlString);
				URLConnection conn = url.openConnection();
				if (!(conn instanceof HttpURLConnection)){
					Log.i("UrlInvalid", ":" + conn);
					throw new IOException("Not an HTTP connection");
				}
				try {
					HttpURLConnection httpConn = (HttpURLConnection) conn;

					Log.i("Step1", ":" + httpConn);
					httpConn.setDoInput(true);
					Log.i("Step2", ":" + httpConn);
					httpConn.connect();
					Log.i("Step3", ":" + httpConn);
					response = httpConn.getResponseCode();
					Log.i("Step4", ":" + httpConn);
					if (response == HttpURLConnection.HTTP_OK) {
						Log.i("Step5", ":" + httpConn);
						in = httpConn.getInputStream();
					}
				} catch (Exception ex) {   
					Log.i("Step6", ":" + ex);
					throw new IOException("Error connecting");
				}
				return in;
			}


			//SEND LOGIN
			public String sendFeedbackCommand(String device, String psw, String cmd, String type, String x, String y, String w, String z){
				byte[] contents = new byte[1024];
				int bytesRead = 0;
				String result = "null";
				try {
					String format = getString(R.string.urlfeed);
					String url = String.format(format, device, psw, cmd, type, x, y, w, z);
					Log.i("URL", ":" + url);
					InputStream inputstream = openHttpConnection(url);
					Log.i("Inputstream", ":" + inputstream);
					InputStream in = new BufferedInputStream(inputstream);
					if((bytesRead = in.read(contents)) != -1){
						result = new String(contents, 0, bytesRead);
					}
					in.close();
					inputstream.close();
				} catch (Exception e) {
					// TODO: handle exception
					e.printStackTrace();
					Log.i("eccez",e.getMessage());
				}
				return result;
			}

}
