/*
 * Decompiled with CFR 0.152.
 */
package com.jjoe64.graphview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import com.jjoe64.graphview.GraphView;
import com.jjoe64.graphview.GraphViewDataInterface;
import com.jjoe64.graphview.GraphViewSeries;

public class LineGraphView
extends GraphView {
    private final Paint paintBackground = new Paint();
    private boolean drawBackground;

    public LineGraphView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.paintBackground.setColor(Color.rgb((int)20, (int)40, (int)60));
        this.paintBackground.setStrokeWidth(4.0f);
    }

    public LineGraphView(Context context, String title) {
        super(context, title);
        this.paintBackground.setColor(Color.rgb((int)20, (int)40, (int)60));
        this.paintBackground.setStrokeWidth(4.0f);
    }

    @Override
    public void drawSeries(Canvas canvas, GraphViewDataInterface[] values, float graphwidth, float graphheight, float border, double minX, double minY, double diffX, double diffY, float horstart, GraphViewSeries.GraphViewSeriesStyle style) {
        double lastEndY = 0.0;
        double lastEndX = 0.0;
        if (this.drawBackground) {
            float startY = graphheight + border;
            int i = 0;
            while (i < values.length) {
                double valY = values[i].getY() - minY;
                double ratY = valY / diffY;
                double y = (double)graphheight * ratY;
                double valX = values[i].getX() - minX;
                double ratX = valX / diffX;
                double x = (double)graphwidth * ratX;
                float endX = (float)x + (horstart + 1.0f);
                float endY = (float)((double)border - y) + graphheight + 2.0f;
                if (i > 0) {
                    double numSpace = ((double)endX - lastEndX) / 3.0 + 1.0;
                    int xi = 0;
                    while ((double)xi < numSpace) {
                        float spaceX = (float)(lastEndX + ((double)endX - lastEndX) * (double)xi / (numSpace - 1.0));
                        float spaceY = (float)(lastEndY + ((double)endY - lastEndY) * (double)xi / (numSpace - 1.0));
                        float startX = spaceX;
                        if (startX - horstart > 1.0f) {
                            canvas.drawLine(startX, startY, spaceX, spaceY, this.paintBackground);
                        }
                        ++xi;
                    }
                }
                lastEndY = endY;
                lastEndX = endX;
                ++i;
            }
        }
        this.paint.setStrokeWidth((float)style.thickness);
        this.paint.setColor(style.color);
        lastEndY = 0.0;
        lastEndX = 0.0;
        int i = 0;
        while (i < values.length) {
            double valY = values[i].getY() - minY;
            double ratY = valY / diffY;
            double y = (double)graphheight * ratY;
            double valX = values[i].getX() - minX;
            double ratX = valX / diffX;
            double x = (double)graphwidth * ratX;
            if (i > 0) {
                float startX = (float)lastEndX + (horstart + 1.0f);
                float startY = (float)((double)border - lastEndY) + graphheight;
                float endX = (float)x + (horstart + 1.0f);
                float endY = (float)((double)border - y) + graphheight;
                canvas.drawLine(startX, startY, endX, endY, this.paint);
            }
            lastEndY = y;
            lastEndX = x;
            ++i;
        }
    }

    public int getBackgroundColor() {
        return this.paintBackground.getColor();
    }

    public boolean getDrawBackground() {
        return this.drawBackground;
    }

    public void setBackgroundColor(int color) {
        this.paintBackground.setColor(color);
    }

    public void setDrawBackground(boolean drawBackground) {
        this.drawBackground = drawBackground;
    }
}

