/*
 * Decompiled with CFR 0.152.
 */
package com.jjoe64.graphview.compatible;

import android.content.Context;
import android.util.Log;
import android.view.MotionEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class ScaleGestureDetector {
    private Object realScaleGestureDetector;
    private Method method_getScaleFactor;
    private Method method_isInProgress;
    private Method method_onTouchEvent;

    public ScaleGestureDetector(Context context, SimpleOnScaleGestureListener simpleOnScaleGestureListener) {
        try {
            Class.forName("android.view.ScaleGestureDetector");
            Class<?> classRealScaleGestureDetector = Class.forName("com.jjoe64.graphview.compatible.RealScaleGestureDetector");
            this.method_getScaleFactor = classRealScaleGestureDetector.getMethod("getScaleFactor", new Class[0]);
            this.method_isInProgress = classRealScaleGestureDetector.getMethod("isInProgress", new Class[0]);
            this.method_onTouchEvent = classRealScaleGestureDetector.getMethod("onTouchEvent", MotionEvent.class);
            Constructor<?> constructor = classRealScaleGestureDetector.getConstructor(Context.class, this.getClass(), SimpleOnScaleGestureListener.class);
            this.realScaleGestureDetector = constructor.newInstance(context, this, simpleOnScaleGestureListener);
        }
        catch (Exception e) {
            Log.w((String)"com.jjoe64.graphview", (String)"*** WARNING *** No scaling available for graphs. Exception:");
            e.printStackTrace();
        }
    }

    public double getScaleFactor() {
        if (this.method_getScaleFactor != null) {
            try {
                return ((Float)this.method_getScaleFactor.invoke(this.realScaleGestureDetector, new Object[0])).floatValue();
            }
            catch (Exception e) {
                e.printStackTrace();
                return 1.0;
            }
        }
        return 1.0;
    }

    public boolean isInProgress() {
        if (this.method_getScaleFactor != null) {
            try {
                return (Boolean)this.method_isInProgress.invoke(this.realScaleGestureDetector, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public void onTouchEvent(MotionEvent event) {
        if (this.method_onTouchEvent != null) {
            try {
                this.method_onTouchEvent.invoke(this.realScaleGestureDetector, event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static interface SimpleOnScaleGestureListener {
        public boolean onScale(ScaleGestureDetector var1);
    }
}

