package it.unimi.di.laren.smartwash.Model;

import it.unimi.di.laren.smartwash.R;

import java.util.List;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;

public class SpinnerItemAdapter extends ArrayAdapter<SpinnerItem>{
	
	private Context context;

	List<SpinnerItem> data = null;
	
	public SpinnerItemAdapter(Context context, List<SpinnerItem> data) 
	{
		//se debe indicar el layout para el item que seleccionado (el que se muestra sobre el botn del botn)
		super(context, R.layout.spinner_selected_item, data);
		this.context = context;
		this.data = data;
	}
	
	//este mtodo establece el elemento seleccionado sobre el botn del spinner
		@Override
		 public View getView(int position, View convertView, ViewGroup parent) 
		 {
		    if (convertView == null) 
		    {
		         convertView = ((LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE)).inflate(R.layout.spinner_selected_item,null);
		    }	        
		    ((TextView) convertView.findViewById(R.id.texto)).setText(data.get(position).getName());
		    ((ImageView) convertView.findViewById(R.id.icono)).setBackgroundResource(data.get(position).getIcon());	   
		    
		    return convertView;
		 }

		//gestiona la lista usando el View Holder Pattern. Equivale a la tpica implementacin del getView
		//de un Adapter de un ListView ordinario
		@Override
		public View getDropDownView(int position, View convertView, ViewGroup parent) 
		{
			View row = convertView;
			if (row == null) 
			{
				LayoutInflater layoutInflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
				row = layoutInflater.inflate(R.layout.spinner_list_item, parent, false);
			}

			if (row.getTag() == null) 
			{
				SpinnerHolder redSocialHolder = new SpinnerHolder();
				redSocialHolder.setIcono((ImageView) row.findViewById(R.id.icono));
				redSocialHolder.setTextView((TextView) row.findViewById(R.id.texto));
				row.setTag(redSocialHolder);
			}

			//rellenamos el layout con los datos de la fila que se est procesando
			SpinnerItem socialNetwork = data.get(position);		
			((SpinnerHolder) row.getTag()).getIcono().setImageResource(socialNetwork.getIcon());		
			((SpinnerHolder) row.getTag()).getTextView().setText(socialNetwork.getName());

			return row;
		}

		private class SpinnerHolder
		{

			private ImageView icono;

			private TextView textView;

			public ImageView getIcono()
			{
				return icono;
			}

			public void setIcono(ImageView icono) 
			{
				this.icono = icono;
			}

			public TextView getTextView() 
			{
				return textView;
			}

			public void setTextView(TextView textView) 
			{
				this.textView = textView;
			}

		}
}
