package it.unimi.di.laren.smartwash.View;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;

import it.unimi.di.laren.smartwash.R;
import it.unimi.di.laren.smartwash.Controller.Submit_Controller;
import android.os.Bundle;
import android.app.Activity;
import android.content.Intent;
import android.graphics.Typeface;
import android.util.Log;
import android.view.KeyEvent;
import android.widget.Button;
import android.widget.TextView;

public class SubmitActivity extends Activity {
	public TextView yourscore;
	public TextView score;
	public TextView yourposition;
	public TextView position;
	public float k = -1;
	public float h = -1;
	public float c = -1;
	public float e = -1;
	public float tot; 
	public String imei;
	public String rank;
	public Button more, scores;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_submit);
		Typeface myTypeface = Typeface.createFromAsset(this.getAssets(),"KabelBold.ttf");
		yourscore = (TextView)findViewById(R.id.txtYourScore);
		yourscore.setTypeface(myTypeface);
		yourposition = (TextView)findViewById(R.id.txtYourPosition);
		yourposition.setTypeface(myTypeface);
		more = (Button)findViewById(R.id.MoreBtn);
		scores = (Button)findViewById(R.id.RangeBtn);
		score = (TextView)findViewById(R.id.txtScore);
		score.setTypeface(myTypeface);
		position = (TextView)findViewById(R.id.txtPosition);
		position.setTypeface(myTypeface);
		Submit_Controller controller = new Submit_Controller(this);
		more.setOnClickListener(controller);
		scores.setOnClickListener(controller);
		Bundle extras = getIntent().getExtras();

		if (extras == null) {
			return;
		}
		else
		{
			k = extras.getFloat("KWH");
			h = extras.getFloat("H2O");
			c = extras.getFloat("CO2");
			e = extras.getFloat("EFF");
			tot = extras.getFloat("TOT");
			rank = extras.getString("RANKING");
			imei = extras.getString("IMEI");
		}

		DecimalFormat df = new DecimalFormat("##.#####");
		score.setText(String.valueOf(df.format(tot)));
		Log.i("ranking", ":" + rank);
		int s = rank.indexOf(".");
		if(rank.substring(s+1).length() > 2){
			rank = rank.substring(0, s+3);
			position.setText(rank);
		}
		else
			position.setText(rank);

	}
	private InputStream openHttpConnection(String urlString) throws IOException {
		InputStream in = null;
		int response = -1;
		URL url = new URL(urlString);
		URLConnection conn = url.openConnection();
		if (!(conn instanceof HttpURLConnection)){
			Log.i("UrlInvalid", ":" + conn);
			throw new IOException("Not an HTTP connection");
		}
		try {
			HttpURLConnection httpConn = (HttpURLConnection) conn;

			Log.i("Step1", ":" + httpConn);
			httpConn.setDoInput(true);
			Log.i("Step2", ":" + httpConn);
			httpConn.connect();
			Log.i("Step3", ":" + httpConn);
			response = httpConn.getResponseCode();
			Log.i("Step4", ":" + httpConn);
			if (response == HttpURLConnection.HTTP_OK) {
				Log.i("Step5", ":" + httpConn);
				in = httpConn.getInputStream();
			}
		} catch (Exception ex) {   
			Log.i("Step6", ":" + ex);
			throw new IOException("Error connecting");
		}
		return in;
	}

	public String returnRange(){
		byte[] contents = new byte[1024];
		int bytesRead = 0;
		String range = "null";
		try {
			String format = getString(R.string.urlrange);
			String url = String.format(format);
			Log.i("URL", ":" + url);
			InputStream inputstream = openHttpConnection(url);
			Log.i("Inputstream", ":" + inputstream);
			InputStream in = new BufferedInputStream(inputstream);
			if((bytesRead = in.read(contents)) != -1){
				range = new String(contents, 0, bytesRead);
			}
			in.close();
			inputstream.close();
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
			Log.i("eccez",e.getMessage());
		}
		return range;
	}



}
