package it.unimi.di.laren.smartwash.View;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;

import it.unimi.di.laren.smartwash.R;
import it.unimi.di.laren.smartwash.Controller.Elaboration_Controller;
import it.unimi.di.laren.smartwash.Model.Database;
import android.os.Build;
import android.os.Bundle;
import android.os.StrictMode;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.view.Menu;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.SeekBar.OnSeekBarChangeListener;
import android.widget.TextView;

@SuppressLint("NewApi")
@TargetApi(Build.VERSION_CODES.GINGERBREAD)
public class ElaborationActivity extends Activity {

	public SeekBar seekbar1 = null;
	public SeekBar seekbar2 = null;
	public SeekBar seekbar3 = null;
	public SeekBar seekbar4 = null;
	public SeekBar seekbar5 = null;
	public SeekBar seekbar6 = null;
	public SeekBar seekbar7 = null;
	public SeekBar seekbar8 = null;
	public SeekBar seekbar9 = null;
	public SeekBar seekbar10 = null;
	public TextView sb1, sb2, sb3, sb4, sb5, sb6, sb7, sb8, sb9, sb10, kilo, wat, co, ef, vkilo, vwat, vco, vef;
	public RelativeLayout fasi1, fasi2, fasi3, fasi4, fasi5, bgr3;
	public ImageButton left, right;
	public Button submit;
	public TextView one, two, three, four, five;
	public int fase = 1;
	public Database database = new Database();
	public int sce = -1;
	public int progressChanged1 = 0;
	public int progressChanged2 = 0;
	public int progressChanged3 = 0;
	public int progressChanged4 = 0;
	public int progressChanged5 = 0;
	public int progressChanged6 = 0;
	public int progressChanged7 = 0;
	public int progressChanged8 = 0;
	public int progressChanged9 = 0;
	public int progressChanged10 = 0;
	public float wa;
	public float cod = 0;
	public float valH2o;
	public float valco2;
	public float valkWh;
	public float valEff;
	public float kilowatt = 0; 
	public float semiSomma;
	public int var_water = 5;
	public int var_time = 5;
	public int var_soap = 10;
	public int var_spin = 100;
	public int var_temp = 10;
	public TelephonyManager telephonyManager;
	public String imei;
	public float eff1 = 0, eff2 = 0, eff3 = 0, eff4 = 0, eff5 = 0, eff6 = 0, eff7 = 0, eff8 = 0, eff9 = 0, eff10 = 0 ;

	@TargetApi(Build.VERSION_CODES.GINGERBREAD)
	@SuppressLint("NewApi")
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_elaboration);
		StrictMode.ThreadPolicy policy = new StrictMode.ThreadPolicy.Builder().permitAll().build();
		StrictMode.setThreadPolicy(policy);
		telephonyManager = (TelephonyManager)getSystemService(Context.TELEPHONY_SERVICE);
		imei = telephonyManager.getDeviceId();
		kilo = (TextView)findViewById(R.id.scoreKwh);
		wat = (TextView)findViewById(R.id.scoreH2o);
		co = (TextView)findViewById(R.id.scoreCO2);
		ef = (TextView)findViewById(R.id.scoreEff);
		vkilo = (TextView)findViewById(R.id.valKwh);
		vwat = (TextView)findViewById(R.id.valH2o);
		vco = (TextView)findViewById(R.id.valCO2);
		vef = (TextView)findViewById(R.id.valEff);
		final DecimalFormat df = new DecimalFormat("##.####");
		final DecimalFormat dfval = new DecimalFormat("##.##");

		Bundle extras = getIntent().getExtras();

		if (extras == null) {
			return;
		}
		else
		{
			sce = extras.getInt("SCELTA");

		}

		Log.i("sceltanuova", ": " + sce);
		database.parameters(sce);
		Log.i("waterda", ": " + database.water1);
		Log.i("waterda", ": " + database.water2);

		bgr3 = (RelativeLayout)findViewById(R.id.arrowlay);
		bgr3.getBackground().setAlpha(95);

		fasi1 = (RelativeLayout)findViewById(R.id.fasiLayout1);
		fasi2 = (RelativeLayout)findViewById(R.id.fasiLayout2);
		fasi3 = (RelativeLayout)findViewById(R.id.fasiLayout3);
		fasi4 = (RelativeLayout)findViewById(R.id.fasiLayout4);
		fasi5 = (RelativeLayout)findViewById(R.id.fasiLayout5);

		submit = (Button)findViewById(R.id.SubmitBtn);

		left = (ImageButton)findViewById(R.id.arrowLeft);
		right = (ImageButton)findViewById(R.id.arrowRight);
		one = (TextView)findViewById(R.id.txt1);
		two = (TextView)findViewById(R.id.txt2);
		three = (TextView)findViewById(R.id.txt3);
		four = (TextView)findViewById(R.id.txt4);
		five = (TextView)findViewById(R.id.txt5);
		one.setTextColor(Color.MAGENTA);


		seekbar1 = (SeekBar)findViewById(R.id.water1_bar);
		sb1 = (TextView)findViewById(R.id.sb1);

		seekbar1.setOnSeekBarChangeListener(new OnSeekBarChangeListener() {

			public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser){
				progressChanged1 = progress;
				sb1.setText("Water: " + progressChanged1 + " lt");

			}

			public void onStartTrackingTouch(SeekBar seekBar) {
				// TODO Auto-generated method stub
			}

			public void onStopTrackingTouch(SeekBar seekBar) {
				float k = (float) 1/valkWh(progressChanged3, progressChanged7, progressChanged9, progressChanged5, progressChanged8, progressChanged10, progressChanged2, progressChanged1);
				float h = totH2O(progressChanged1, progressChanged6);
				float c =totCO2(cod);
				float vk = valkWh(progressChanged3, progressChanged7, progressChanged9, progressChanged5, progressChanged8, progressChanged10, progressChanged2, progressChanged1);

				float vh = valH2O(progressChanged1, progressChanged6);
				float vc = valCO2(progressChanged4, progressChanged1, progressChanged6);
				eff1 = calcEff_i(database.water1, progressChanged1, var_water);
				float tE = sommaEff(eff1, eff2, eff3, eff4, eff5, eff6, eff7, eff8, eff9, eff10);
				float ttt = (float) Math.log10(tE);
				float e = totEff(ttt);
				ef.setText(String.valueOf(df.format(e)));
				kilo.setText(String.valueOf(df.format(k)));
				wat.setText(String.valueOf(df.format(h)));
				co.setText(String.valueOf(df.format(c)));

				vkilo.setText(String.valueOf(dfval.format(vk))+"kWh");
				vwat.setText(String.valueOf(dfval.format(vh))+"lt");
				vco.setText(String.valueOf(dfval.format(vc))+"kg");
			}
		});

		seekbar2 = (SeekBar)findViewById(R.id.temperature1_bar);
		sb2 = (TextView)findViewById(R.id.sb2);

		seekbar2.setOnSeekBarChangeListener(new OnSeekBarChangeListener() {
			//int progressChanged2 = 0;

			public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser){
				progressChanged2 = progress;
				sb2.setText("Temperature: " + progressChanged2 + "C");

			}

			public void onStartTrackingTouch(SeekBar seekBar) {
				// TODO Auto-generated method stub
			}

			public void onStopTrackingTouch(SeekBar seekBar) {
				float k = (float) 1/valkWh(progressChanged3, progressChanged7, progressChanged9, progressChanged5, progressChanged8, progressChanged10, progressChanged2, progressChanged1);
				float h = totH2O(progressChanged1, progressChanged6);
				float c =totCO2(cod);
				float vk = valkWh(progressChanged3, progressChanged7, progressChanged9, progressChanged5, progressChanged8, progressChanged10, progressChanged2, progressChanged1);

				float vh = valH2O(progressChanged1, progressChanged6);
				float vc = valCO2(progressChanged4, progressChanged1, progressChanged6);
				eff2 = calcEff_i(database.temp, progressChanged1, var_temp);
				float tE = sommaEff(eff1, eff2, eff3, eff4, eff5, eff6, eff7, eff8, eff9, eff10);
				float ttt = (float) Math.log10(tE);
				float e = totEff(ttt);
				ef.setText(String.valueOf(df.format(e)));
				kilo.setText(String.valueOf(df.format(k)));
				wat.setText(String.valueOf(df.format(h)));
				co.setText(String.valueOf(df.format(c)));

				vkilo.setText(String.valueOf(dfval.format(vk))+"kWh");
				vwat.setText(String.valueOf(dfval.format(vh))+"lt");
				vco.setText(String.valueOf(dfval.format(vc))+"kg");
			}
		});

		seekbar3 = (SeekBar)findViewById(R.id.spin2_bar);
		sb3 = (TextView)findViewById(R.id.sb3);

		seekbar3.setOnSeekBarChangeListener(new OnSeekBarChangeListener() {
			//int progressChanged3 = 0;

			public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser){
				progressChanged3 = progress;
				sb3.setText("Spin: " + progressChanged3 + " rpm");

			}

			public void onStartTrackingTouch(SeekBar seekBar) {
				// TODO Auto-generated method stub
			}

			public void onStopTrackingTouch(SeekBar seekBar) {
				float k = (float) 1/valkWh(progressChanged3, progressChanged7, progressChanged9, progressChanged5, progressChanged8, progressChanged10, progressChanged2, progressChanged1);
				float h = totH2O(progressChanged1, progressChanged6);
				float c =totCO2(cod);
				float vk = valkWh(progressChanged3, progressChanged7, progressChanged9, progressChanged5, progressChanged8, progressChanged10, progressChanged2, progressChanged1);

				float vh = valH2O(progressChanged1, progressChanged6);
				float vc = valCO2(progressChanged4, progressChanged1, progressChanged6);
				eff3 = calcEff_i(database.spin1, progressChanged1, var_spin);
				float tE = sommaEff(eff1, eff2, eff3, eff4, eff5, eff6, eff7, eff8, eff9, eff10);
				float ttt = (float) Math.log10(tE);
				float e = totEff(ttt);
				ef.setText(String.valueOf(df.format(e)));
				kilo.setText(String.valueOf(df.format(k)));
				wat.setText(String.valueOf(df.format(h)));
				co.setText(String.valueOf(df.format(c)));

				vkilo.setText(String.valueOf(dfval.format(vk))+"kWh");
				vwat.setText(String.valueOf(dfval.format(vh))+"lt");
				vco.setText(String.valueOf(dfval.format(vc))+"kg");
			}
		});

		seekbar4 = (SeekBar)findViewById(R.id.soap2_bar);
		sb4 = (TextView)findViewById(R.id.sb4);

		seekbar4.setOnSeekBarChangeListener(new OnSeekBarChangeListener() {
			//int progressChanged4 = 0;

			public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser){
				progressChanged4 = progress;
				sb4.setText("Soap: " + progressChanged4 + " ml");

			}

			public void onStartTrackingTouch(SeekBar seekBar) {
				// TODO Auto-generated method stub
			}

			public void onStopTrackingTouch(SeekBar seekBar) {
				float k = (float) 1/valkWh(progressChanged3, progressChanged7, progressChanged9, progressChanged5, progressChanged8, progressChanged10, progressChanged2, progressChanged1);
				float h = totH2O(progressChanged1, progressChanged6);
				float c =totCO2(cod);
				float vk = valkWh(progressChanged3, progressChanged7, progressChanged9, progressChanged5, progressChanged8, progressChanged10, progressChanged2, progressChanged1);

				float vh = valH2O(progressChanged1, progressChanged6);
				float vc = valCO2(progressChanged4, progressChanged1, progressChanged6);
				eff4 = calcEff_i(database.soap, progressChanged1, var_soap);
				float tE = sommaEff(eff1, eff2, eff3, eff4, eff5, eff6, eff7, eff8, eff9, eff10);
				float ttt = (float) Math.log10(tE);
				float e = totEff(ttt);
				ef.setText(String.valueOf(df.format(e)));
				kilo.setText(String.valueOf(df.format(k)));
				wat.setText(String.valueOf(df.format(h)));
				co.setText(String.valueOf(df.format(c)));

				vkilo.setText(String.valueOf(dfval.format(vk))+"kWh");
				vwat.setText(String.valueOf(dfval.format(vh))+"lt");
				vco.setText(String.valueOf(dfval.format(vc))+"kg");
			}
		});

		seekbar5 = (SeekBar) findViewById(R.id.time2_bar);
		sb5 = (TextView)findViewById(R.id.sb5);

		seekbar5.setOnSeekBarChangeListener(new OnSeekBarChangeListener() {
			//int progressChanged5 = 0;

			public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser){
				progressChanged5 = progress;
				sb5.setText("Time: " + progressChanged5 + " min");

			}

			public void onStartTrackingTouch(SeekBar seekBar) {
				// TODO Auto-generated method stub
			}

			public void onStopTrackingTouch(SeekBar seekBar) {
				float k = (float) 1/valkWh(progressChanged3, progressChanged7, progressChanged9, progressChanged5, progressChanged8, progressChanged10, progressChanged2, progressChanged1);
				float h = totH2O(progressChanged1, progressChanged6);
				float c =totCO2(cod);
				float vk = valkWh(progressChanged3, progressChanged7, progressChanged9, progressChanged5, progressChanged8, progressChanged10, progressChanged2, progressChanged1);

				float vh = valH2O(progressChanged1, progressChanged6);
				float vc = valCO2(progressChanged4, progressChanged1, progressChanged6);
				eff5 = calcEff_i(database.time1, progressChanged1, var_time);
				float tE = sommaEff(eff1, eff2, eff3, eff4, eff5, eff6, eff7, eff8, eff9, eff10);
				float ttt = (float) Math.log10(tE);
				float e = totEff(ttt);
				ef.setText(String.valueOf(df.format(e)));
				kilo.setText(String.valueOf(df.format(k)));
				wat.setText(String.valueOf(df.format(h)));
				co.setText(String.valueOf(df.format(c)));

				vkilo.setText(String.valueOf(dfval.format(vk))+"kWh");
				vwat.setText(String.valueOf(dfval.format(vh))+"lt");
				vco.setText(String.valueOf(dfval.format(vc))+"kg");
			}
		});

		seekbar6 = (SeekBar) findViewById(R.id.water3_bar);
		sb6 = (TextView)findViewById(R.id.sb6);

		seekbar6.setOnSeekBarChangeListener(new OnSeekBarChangeListener() {
			//int progressChanged6 = 0;

			public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser){
				progressChanged6 = progress;
				sb6.setText("Water: " + progressChanged6 + " lt");

			}

			public void onStartTrackingTouch(SeekBar seekBar) {
				// TODO Auto-generated method stub
			}

			public void onStopTrackingTouch(SeekBar seekBar) {
				float k = (float) 1/valkWh(progressChanged3, progressChanged7, progressChanged9, progressChanged5, progressChanged8, progressChanged10, progressChanged2, progressChanged1);
				float h = totH2O(progressChanged1, progressChanged6);
				float c =totCO2(cod);
				float vk = valkWh(progressChanged3, progressChanged7, progressChanged9, progressChanged5, progressChanged8, progressChanged10, progressChanged2, progressChanged1);

				float vh = valH2O(progressChanged1, progressChanged6);
				float vc = valCO2(progressChanged4, progressChanged1, progressChanged6);
				eff6 = calcEff_i(database.water2, progressChanged1, var_water);
				float tE = sommaEff(eff1, eff2, eff3, eff4, eff5, eff6, eff7, eff8, eff9, eff10);
				float ttt = (float) Math.log10(tE);
				float e = totEff(ttt);
				ef.setText(String.valueOf(df.format(e)));
				kilo.setText(String.valueOf(df.format(k)));
				wat.setText(String.valueOf(df.format(h)));
				co.setText(String.valueOf(df.format(c)));

				vkilo.setText(String.valueOf(dfval.format(vk))+"kWh");
				vwat.setText(String.valueOf(dfval.format(vh))+"lt");
				vco.setText(String.valueOf(dfval.format(vc))+"kg");
			}
		});

		seekbar7 = (SeekBar) findViewById(R.id.spin3_bar);
		sb7 = (TextView)findViewById(R.id.sb7);

		seekbar7.setOnSeekBarChangeListener(new OnSeekBarChangeListener() {
			//int progressChanged7 = 0;

			public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser){
				progressChanged7 = progress;
				sb7.setText("Spin: " + progressChanged7 + " rpm");

			}

			public void onStartTrackingTouch(SeekBar seekBar) {
				// TODO Auto-generated method stub
			}

			public void onStopTrackingTouch(SeekBar seekBar) {
				float k = (float) 1/valkWh(progressChanged3, progressChanged7, progressChanged9, progressChanged5, progressChanged8, progressChanged10, progressChanged2, progressChanged1);
				float h = totH2O(progressChanged1, progressChanged6);
				float c =totCO2(cod);
				float vk = valkWh(progressChanged3, progressChanged7, progressChanged9, progressChanged5, progressChanged8, progressChanged10, progressChanged2, progressChanged1);

				float vh = valH2O(progressChanged1, progressChanged6);
				float vc = valCO2(progressChanged4, progressChanged1, progressChanged6);
				eff7 = calcEff_i(database.spin2, progressChanged1, var_spin);
				float tE = sommaEff(eff1, eff2, eff3, eff4, eff5, eff6, eff7, eff8, eff9, eff10);
				float ttt = (float) Math.log10(tE);
				float e = totEff(ttt);
				ef.setText(String.valueOf(df.format(e)));
				kilo.setText(String.valueOf(df.format(k)));
				wat.setText(String.valueOf(df.format(h)));
				co.setText(String.valueOf(df.format(c)));

				vkilo.setText(String.valueOf(dfval.format(vk))+"kWh");
				vwat.setText(String.valueOf(dfval.format(vh))+"lt");
				vco.setText(String.valueOf(dfval.format(vc))+"kg");
			}
		});

		seekbar8 = (SeekBar) findViewById(R.id.time3_bar);
		sb8 = (TextView)findViewById(R.id.sb8);

		seekbar8.setOnSeekBarChangeListener(new OnSeekBarChangeListener() {
			//int progressChanged8 = 0;

			public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser){
				progressChanged8 = progress;
				sb8.setText("Time: " + progressChanged8 + " min");

			}

			public void onStartTrackingTouch(SeekBar seekBar) {
				// TODO Auto-generated method stub
			}

			public void onStopTrackingTouch(SeekBar seekBar) {
				float k = (float) 1/valkWh(progressChanged3, progressChanged7, progressChanged9, progressChanged5, progressChanged8, progressChanged10, progressChanged2, progressChanged1);
				float h = totH2O(progressChanged1, progressChanged6);
				float c =totCO2(cod);
				float vk = valkWh(progressChanged3, progressChanged7, progressChanged9, progressChanged5, progressChanged8, progressChanged10, progressChanged2, progressChanged1);

				float vh = valH2O(progressChanged1, progressChanged6);
				float vc = valCO2(progressChanged4, progressChanged1, progressChanged6);
				eff8 = calcEff_i(database.time2, progressChanged1, var_time);
				float tE = sommaEff(eff1, eff2, eff3, eff4, eff5, eff6, eff7, eff8, eff9, eff10);
				float ttt = (float) Math.log10(tE);
				float e = totEff(ttt);
				ef.setText(String.valueOf(df.format(e)));
				kilo.setText(String.valueOf(df.format(k)));
				wat.setText(String.valueOf(df.format(h)));
				co.setText(String.valueOf(df.format(c)));

				vkilo.setText(String.valueOf(dfval.format(vk))+"kWh");
				vwat.setText(String.valueOf(dfval.format(vh))+"lt");
				vco.setText(String.valueOf(dfval.format(vc))+"kg");
			}
		});

		seekbar9 = (SeekBar) findViewById(R.id.spin4_bar);
		sb9 = (TextView)findViewById(R.id.sb9);

		seekbar9.setOnSeekBarChangeListener(new OnSeekBarChangeListener() {
			//int progressChanged9 = 0;

			public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser){
				progressChanged9 = progress;
				sb9.setText("Spin: " + progressChanged9 + " rpm");
			}

			public void onStartTrackingTouch(SeekBar seekBar) {
				// TODO Auto-generated method stub
			}

			public void onStopTrackingTouch(SeekBar seekBar) {
				float k = (float) 1/valkWh(progressChanged3, progressChanged7, progressChanged9, progressChanged5, progressChanged8, progressChanged10, progressChanged2, progressChanged1);
				float h = totH2O(progressChanged1, progressChanged6);
				float c =totCO2(cod);
				float vk = valkWh(progressChanged3, progressChanged7, progressChanged9, progressChanged5, progressChanged8, progressChanged10, progressChanged2, progressChanged1);
				float vh = valH2O(progressChanged1, progressChanged6);
				float vc = valCO2(progressChanged4, progressChanged1, progressChanged6);
				eff9 = calcEff_i(database.spin3, progressChanged1, var_spin);
				float tE = sommaEff(eff1, eff2, eff3, eff4, eff5, eff6, eff7, eff8, eff9, eff10);
				float ttt = (float) Math.log10(tE);
				float e = totEff(ttt);
				ef.setText(String.valueOf(df.format(e)));
				kilo.setText(String.valueOf(df.format(k)));
				wat.setText(String.valueOf(df.format(h)));
				co.setText(String.valueOf(df.format(c)));

				vkilo.setText(String.valueOf(dfval.format(vk))+"kWh");
				vwat.setText(String.valueOf(dfval.format(vh))+"lt");
				vco.setText(String.valueOf(dfval.format(vc))+"kg");
			}
		});

		seekbar10 = (SeekBar) findViewById(R.id.time4_bar);
		sb10 = (TextView)findViewById(R.id.sb10);

		seekbar10.setOnSeekBarChangeListener(new OnSeekBarChangeListener() {
			//int progressChanged10 = 0;

			public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser){
				progressChanged10 = progress;
				sb10.setText("Time: " + progressChanged10 + " min");

			}

			public void onStartTrackingTouch(SeekBar seekBar) {
				// TODO Auto-generated method stub
			}

			public void onStopTrackingTouch(SeekBar seekBar) {
				float k = (float) 1/valkWh(progressChanged3, progressChanged7, progressChanged9, progressChanged5, progressChanged8, progressChanged10, progressChanged2, progressChanged1);
				float h = totH2O(progressChanged1, progressChanged6);
				float c =totCO2(cod);
				float vk = valkWh(progressChanged3, progressChanged7, progressChanged9, progressChanged5, progressChanged8, progressChanged10, progressChanged2, progressChanged1);
				float vh = valH2O(progressChanged1, progressChanged6);
				float vc = valCO2(progressChanged4, progressChanged1, progressChanged6);
				eff10 = calcEff_i(database.time3, progressChanged1, var_time);
				float tE = sommaEff(eff1, eff2, eff3, eff4, eff5, eff6, eff7, eff8, eff9, eff10);
				float ttt = (float) Math.log10(tE);
				float e = totEff(ttt);
				ef.setText(String.valueOf(df.format(e)));
				kilo.setText(String.valueOf(df.format(k)));
				wat.setText(String.valueOf(df.format(h)));
				co.setText(String.valueOf(df.format(c)));

				vkilo.setText(String.valueOf(dfval.format(vk))+"kWh");
				vwat.setText(String.valueOf(dfval.format(vh))+"lt");
				vco.setText(String.valueOf(dfval.format(vc))+"kg");
				
			}
		});

		Elaboration_Controller controller = new Elaboration_Controller(this);
		left.setOnClickListener(controller);
		right.setOnClickListener(controller);
		submit.setOnClickListener(controller);
	}

	
	public float totH2O(int w1, int w2){
		int w = w1 + w2;
		valH2o = ((float) Math.pow((float)w, -1))*10;
		return valH2o;
	}
	public float totCO2(float cod2){
		valco2 = (float) Math.exp(-((float)cod2/10));
		return valco2;
	}

	public float totkWh(int s1, int s2, int s3, int t1, int t2, int t3, int te1, int w){
		float somma =(float) ((Math.pow(((float)s1)/1000, 2)*(float)t1) + (Math.pow(((float)s2)/1000, 2)*(float)t2) + (Math.pow(((float)s3)/1000, 2)*(float)t3) + (10*Math.pow(((float)te1)*0.01,2))*(float)w);
		valkWh = (float) 1/somma;
		return valkWh;
	}
	public float valH2O(int w1, int w2){
		int w = w1 + w2;
		return w;
	}
	public float valCO2(float k, int w1, int w2){
		cod = (float) k/(w1+w2);
		return cod;
	}

	public float valkWh(int s1, int s2, int s3, int t1, int t2, int t3, int te1, int w1){
		if(te1>20){
			kilowatt = (float) ((((float)w1)*((float)te1-20)*0.0016)*(1+(0.2*((float)t1/60))))+(((float)s1/1200)*((float)t1/60))+(((float)s2/1200)*((float)t2/60))+(((float)s3/1200)*((float)t3/60));
		}
		else{
			kilowatt = (float) ((((float)w1)*(0)*0.0016)*(1+(0.2*((float)t1/60))))+(((float)s1/1200)*((float)t1/60))+(((float)s2/1200)*((float)t2/60))+(((float)s3/1200)*((float)t3/60));
		}
		return kilowatt;
	}
	public float calcEff_i(int t_i, int s_i, int var){
		float sig = (float) Math.sqrt(var);
		semiSomma = (float) Math.pow(((t_i - s_i)/sig),2);
		return semiSomma;
	}
	public float sommaEff(float e1, float e2, float e3, float e4, float e5, float e6, float e7, float e8, float e9, float e10){
		float somma = e1+e2+e3+e4+e5+e6+e7+e8+e9+e10;
		return somma;
	}
	public float totEff(float tot){
		valEff = (float) ((float) 1/tot);
		return valEff;
	}

	
	 private InputStream openHttpConnection(String urlString) throws IOException {
	        InputStream in = null;
	        int response = -1;
	        URL url = new URL(urlString);
	        URLConnection conn = url.openConnection();
	        if (!(conn instanceof HttpURLConnection)){
	        	Log.i("UrlInvalid", ":" + conn);
	            throw new IOException("Not an HTTP connection");
	        }
	        try {
	            HttpURLConnection httpConn = (HttpURLConnection) conn;
	            
	            Log.i("Step1", ":" + httpConn);
	            httpConn.setDoInput(true);
	            Log.i("Step2", ":" + httpConn);
	            httpConn.connect();
	            Log.i("Step3", ":" + httpConn);
	            response = httpConn.getResponseCode();
	            Log.i("Step4", ":" + httpConn);
	            if (response == HttpURLConnection.HTTP_OK) {
	            	Log.i("Step5", ":" + httpConn);
	                in = httpConn.getInputStream();
	            }
	        } catch (Exception ex) {   
	        	Log.i("Step6", ":" + ex);
	            throw new IOException("Error connecting");
	        }
	        return in;
	    }

	public String sendHttpScore(float score, int code){
		byte[] contents = new byte[1024];
		int bytesRead = 0;
		String result = "null";
		try {
			String format = getString(R.string.url);
			String url = String.format(format, imei, String.valueOf(score), String.valueOf(code));
			Log.i("URL", ":" + url);
			InputStream inputstream = openHttpConnection(url);
			Log.i("Inputstream", ":" + inputstream);
			InputStream in = new BufferedInputStream(inputstream);
			if((bytesRead = in.read(contents)) != -1){
				result = new String(contents, 0, bytesRead);
			}
			in.close();
			inputstream.close();
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
			Log.i("eccez",e.getMessage());
		}
		return result;
	}

}
